/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.index.impl.lucene.CommitContext;
import org.neo4j.index.impl.lucene.EntityId;
import org.neo4j.index.impl.lucene.IndexIdentifier;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;

public class LuceneCommandApplier
extends NeoCommandHandler.Adapter {
    private final LuceneDataSource dataSource;
    private final Map<String, CommitContext> nodeContexts = new HashMap<String, CommitContext>();
    private final Map<String, CommitContext> relationshipContexts = new HashMap<String, CommitContext>();
    private final boolean recovery;
    private IndexDefineCommand definitions;

    public LuceneCommandApplier(LuceneDataSource dataSource, boolean recovery) {
        this.dataSource = dataSource;
        this.recovery = recovery;
    }

    public boolean visitIndexAddNodeCommand(IndexCommand.AddNodeCommand command) throws IOException {
        CommitContext context = this.commitContext((IndexCommand)command);
        String key = this.definitions.getKey(command.getKeyId());
        Object value = command.getValue();
        context.ensureWriterInstantiated();
        context.indexType.addToDocument(context.getDocument((EntityId)new EntityId.IdData((long)command.getEntityId()), (boolean)true).document, key, value);
        return false;
    }

    public boolean visitIndexAddRelationshipCommand(IndexCommand.AddRelationshipCommand command) throws IOException {
        CommitContext context = this.commitContext((IndexCommand)command);
        String key = this.definitions.getKey(command.getKeyId());
        Object value = command.getValue();
        context.ensureWriterInstantiated();
        EntityId.RelationshipData entityId = new EntityId.RelationshipData(command.getEntityId(), command.getStartNode(), command.getEndNode());
        context.indexType.addToDocument(context.getDocument((EntityId)entityId, (boolean)true).document, key, value);
        return false;
    }

    public boolean visitIndexRemoveCommand(IndexCommand.RemoveCommand command) throws IOException {
        CommitContext context = this.commitContext((IndexCommand)command);
        String key = this.definitions.getKey(command.getKeyId());
        Object value = command.getValue();
        context.ensureWriterInstantiated();
        CommitContext.DocumentContext document = context.getDocument(new EntityId.IdData(command.getEntityId()), false);
        if (document != null) {
            context.indexType.removeFromDocument(document.document, key, value);
        }
        return false;
    }

    public boolean visitIndexDeleteCommand(IndexCommand.DeleteCommand command) throws IOException {
        CommitContext context = this.commitContext((IndexCommand)command);
        context.documents.clear();
        context.dataSource.deleteIndex(context.identifier, context.recovery);
        return false;
    }

    public boolean visitIndexCreateCommand(IndexCommand.CreateCommand createCommand) throws IOException {
        return false;
    }

    public boolean visitIndexDefineCommand(IndexDefineCommand indexDefineCommand) throws IOException {
        this.definitions = indexDefineCommand;
        return false;
    }

    public void apply() {
        try {
            if (this.definitions != null) {
                this.dataSource.getWriteLock();
                for (CommitContext context : this.nodeContexts.values()) {
                    context.close();
                }
                for (CommitContext context : this.relationshipContexts.values()) {
                    context.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failure to commit changes to lucene", e);
        }
    }

    public void close() {
        if (this.definitions != null) {
            this.dataSource.releaseWriteLock();
        }
    }

    private CommitContext commitContext(IndexCommand command) {
        String indexName;
        Map<String, CommitContext> contextMap = this.commitContextMap(command.getEntityType());
        CommitContext context = contextMap.get(indexName = this.definitions.getIndexName(command.getIndexNameId()));
        if (context == null) {
            IndexIdentifier identifier = new IndexIdentifier(IndexEntityType.byId((byte)command.getEntityType()), indexName);
            context = new CommitContext(this.dataSource, identifier, this.dataSource.getType(identifier, this.recovery), this.recovery);
            contextMap.put(indexName, context);
        }
        return context;
    }

    private Map<String, CommitContext> commitContextMap(byte entityType) {
        if (entityType == IndexEntityType.Node.id()) {
            return this.nodeContexts;
        }
        if (entityType == IndexEntityType.Relationship.id()) {
            return this.relationshipContexts;
        }
        throw new IllegalArgumentException("Unknown entity type " + entityType);
    }
}

