/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.direct.AllEntriesLabelScanReader;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterFactory;
import org.neo4j.kernel.api.impl.index.LabelScanStorageStrategy;
import org.neo4j.kernel.api.impl.index.LuceneIndexWriter;
import org.neo4j.kernel.api.impl.index.LuceneSnapshotter;
import org.neo4j.kernel.api.labelscan.LabelScanReader;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class LuceneLabelScanStore
implements LabelScanStore,
LabelScanStorageStrategy.StorageService {
    private final LabelScanStorageStrategy strategy;
    private final DirectoryFactory directoryFactory;
    private final IndexWriterFactory<LuceneIndexWriter> writerFactory;
    private final LabelScanStoreProvider.FullStoreChangeStream fullStoreStream;
    private final Monitor monitor;
    private Directory directory;
    private SearcherManager searcherManager;
    private LuceneIndexWriter writer;
    private boolean needsRebuild;
    private final File directoryLocation;
    private final FileSystemAbstraction fs;
    private final Lock lock = new ReentrantLock(true);

    public static Monitor loggerMonitor(Logging logging) {
        final StringLogger logger = logging.getMessagesLog(LuceneLabelScanStore.class);
        return new Monitor(){

            @Override
            public void init() {
            }

            @Override
            public void noIndex() {
                logger.info("No lucene scan store index found, this might just be first use. Preparing to rebuild.");
            }

            @Override
            public void lockedIndex(LockObtainFailedException e) {
                logger.warn("Index is locked by another process or database", (Throwable)e);
            }

            @Override
            public void corruptIndex(IOException corruptionException) {
                logger.warn("Lucene scan store index could not be read. Preparing to rebuild.", (Throwable)corruptionException);
            }

            @Override
            public void rebuilding() {
                logger.info("Rebuilding lucene scan store, this may take a while");
            }

            @Override
            public void rebuilt(long highNodeId) {
                logger.info("Lucene scan store rebuilt (roughly " + highNodeId + " nodes)");
            }
        };
    }

    public LuceneLabelScanStore(LabelScanStorageStrategy strategy, DirectoryFactory directoryFactory, File directoryLocation, FileSystemAbstraction fs, IndexWriterFactory<LuceneIndexWriter> writerFactory, LabelScanStoreProvider.FullStoreChangeStream fullStoreStream, Monitor monitor) {
        this.strategy = strategy;
        this.directoryFactory = directoryFactory;
        this.directoryLocation = directoryLocation;
        this.fs = fs;
        this.writerFactory = writerFactory;
        this.fullStoreStream = fullStoreStream;
        this.monitor = monitor;
    }

    @Override
    public void deleteDocuments(Term documentTerm) throws IOException {
        this.writer.deleteDocuments(documentTerm);
    }

    @Override
    public void updateDocument(Term documentTerm, Document document) throws IOException, IndexCapacityExceededException {
        this.writer.updateDocument(documentTerm, document);
    }

    @Override
    public IndexSearcher acquireSearcher() {
        return (IndexSearcher)this.searcherManager.acquire();
    }

    @Override
    public void refreshSearcher() throws IOException {
        this.searcherManager.maybeRefresh();
    }

    @Override
    public void releaseSearcher(IndexSearcher searcher) throws IOException {
        this.searcherManager.release((Object)searcher);
    }

    public AllEntriesLabelScanReader newAllEntriesReader() {
        return this.strategy.newNodeLabelReader(this.searcherManager);
    }

    public void force() {
        try {
            this.writer.commit();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    public LabelScanReader newReader() {
        final IndexSearcher searcher = this.acquireSearcher();
        return new LabelScanReader(){

            public PrimitiveLongIterator nodesWithLabel(int labelId) {
                return LuceneLabelScanStore.this.strategy.nodesWithLabel(searcher, labelId);
            }

            public void close() {
                try {
                    LuceneLabelScanStore.this.releaseSearcher(searcher);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public Iterator<Long> labelsForNode(long nodeId) {
                return LuceneLabelScanStore.this.strategy.labelsForNode(searcher, nodeId);
            }
        };
    }

    public ResourceIterator<File> snapshotStoreFiles() throws IOException {
        return new LuceneSnapshotter().snapshot(this.directoryLocation, this.writer);
    }

    public void init() throws IOException {
        this.monitor.init();
        this.directory = this.directoryFactory.open(this.directoryLocation);
        if (!this.indexExists()) {
            this.monitor.noIndex();
            this.prepareRebuildOfIndex();
        }
        try {
            IndexReader.open((Directory)this.directory).close();
            this.writer = this.writerFactory.create(this.directory);
        }
        catch (IndexNotFoundException e) {
            this.monitor.noIndex();
            this.prepareRebuildOfIndex();
            this.writer = this.writerFactory.create(this.directory);
        }
        catch (LockObtainFailedException e) {
            this.monitor.lockedIndex(e);
            throw e;
        }
        catch (IOException e) {
            this.monitor.corruptIndex(e);
            throw new IOException("Label scan store could not be read, and needs to be rebuilt. To trigger a rebuild, ensure the database is stopped, delete the files in '" + this.directoryLocation.getAbsolutePath() + "', and then start the database again.");
        }
        this.searcherManager = this.writer.createSearcherManager();
    }

    public void start() throws IOException, IndexCapacityExceededException {
        if (this.needsRebuild) {
            this.monitor.rebuilding();
            this.write(this.fullStoreStream.iterator());
            this.monitor.rebuilt(this.fullStoreStream.highestNodeId());
            this.needsRebuild = false;
        }
    }

    private void write(Iterator<NodeLabelUpdate> updates) throws IOException, IndexCapacityExceededException {
        try (LabelScanWriter writer = this.newWriter();){
            while (updates.hasNext()) {
                writer.write(updates.next());
            }
        }
    }

    public void stop() {
    }

    public void shutdown() throws IOException {
        this.searcherManager.close();
        this.writer.close(true);
        this.directory.close();
        this.directory = null;
    }

    public LabelScanWriter newWriter() {
        this.lock.lock();
        return this.strategy.acquireWriter(this, this.lock);
    }

    private boolean indexExists() {
        if (!this.fs.fileExists(this.directoryLocation)) {
            return false;
        }
        File[] files = this.fs.listFiles(this.directoryLocation);
        return files != null && files.length > 0;
    }

    private void prepareRebuildOfIndex() throws IOException {
        this.directory.close();
        this.fs.deleteRecursively(this.directoryLocation);
        this.fs.mkdirs(this.directoryLocation);
        this.needsRebuild = true;
        this.directory = this.directoryFactory.open(this.directoryLocation);
    }

    public static interface Monitor {
        public void init();

        public void noIndex();

        public void lockedIndex(LockObtainFailedException var1);

        public void corruptIndex(IOException var1);

        public void rebuilding();

        public void rebuilt(long var1);
    }
}

