/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.neo4j.index.impl.lucene.Hits;
import org.neo4j.index.impl.lucene.IndexType;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.index.impl.lucene.LuceneIndex;
import org.neo4j.index.impl.lucene.RelationshipId;
import org.neo4j.index.impl.lucene.TxData;
import org.neo4j.index.impl.lucene.TxDataHolder;
import org.neo4j.index.lucene.QueryContext;

class FullTxData
extends TxData {
    private static final String ORPHANS_KEY = "__all__";
    private static final String ORPHANS_VALUE = "1";
    private Directory directory;
    private IndexWriter writer;
    private boolean modified;
    private IndexReader reader;
    private IndexSearcher searcher;
    private final Map<Long, Document> cachedDocuments = new HashMap<Long, Document>();
    private Set<String> orphans;

    FullTxData(LuceneIndex index) {
        super(index);
    }

    @Override
    void add(TxDataHolder holder, Object entityId, String key, Object value) {
        try {
            this.ensureLuceneDataInstantiated();
            long id = entityId instanceof Long ? (Long)entityId : ((RelationshipId)entityId).id;
            Document document = this.findDocument(id);
            boolean add = false;
            if (document == null) {
                document = IndexType.newDocument(entityId);
                this.cachedDocuments.put(id, document);
                add = true;
            }
            if (key == null && value == null) {
                document.add((Fieldable)new Field(ORPHANS_KEY, ORPHANS_VALUE, Field.Store.NO, Field.Index.NOT_ANALYZED));
                this.addOrphan(null);
            } else if (value == null) {
                document.add((Fieldable)new Field(ORPHANS_KEY, key, Field.Store.NO, Field.Index.NOT_ANALYZED));
                this.addOrphan(key);
            } else {
                this.index.type.addToDocument(document, key, value);
            }
            if (add) {
                this.writer.addDocument(document);
            } else {
                this.writer.updateDocument(this.index.type.idTerm(id), document);
            }
            this.invalidateSearcher();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addOrphan(String key) {
        if (this.orphans == null) {
            this.orphans = new HashSet<String>();
        }
        this.orphans.add(key);
    }

    private Document findDocument(long id) {
        return this.cachedDocuments.get(id);
    }

    private void ensureLuceneDataInstantiated() {
        if (this.directory == null) {
            try {
                this.directory = new RAMDirectory();
                IndexWriterConfig writerConfig = new IndexWriterConfig(LuceneDataSource.LUCENE_VERSION, this.index.type.analyzer);
                this.writer = new IndexWriter(this.directory, writerConfig);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    void remove(TxDataHolder holder, Object entityId, String key, Object value) {
        try {
            this.ensureLuceneDataInstantiated();
            long id = entityId instanceof Long ? (Long)entityId : ((RelationshipId)entityId).id;
            Document document = this.findDocument(id);
            if (document != null) {
                this.index.type.removeFromDocument(document, key, value);
                if (LuceneDataSource.documentIsEmpty(document)) {
                    this.writer.deleteDocuments(this.index.type.idTerm(id));
                } else {
                    this.writer.updateDocument(this.index.type.idTerm(id), document);
                }
            }
            this.invalidateSearcher();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    Collection<Long> query(TxDataHolder holder, Query query, QueryContext contextOrNull) {
        return this.internalQuery(query, contextOrNull);
    }

    private Collection<Long> internalQuery(Query query, QueryContext contextOrNull) {
        if (this.directory == null) {
            return Collections.emptySet();
        }
        try {
            Sort sorting = contextOrNull != null ? contextOrNull.getSorting() : null;
            boolean prioritizeCorrectness = contextOrNull == null || !contextOrNull.getTradeCorrectnessForSpeed();
            IndexSearcher theSearcher = this.searcher(prioritizeCorrectness);
            query = this.includeOrphans(query);
            Hits hits = new Hits(theSearcher, query, null, sorting, prioritizeCorrectness);
            ArrayList<Long> result = new ArrayList<Long>();
            for (int i = 0; i < hits.length(); ++i) {
                result.add(Long.valueOf(hits.doc(i).get("_id_")));
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Query includeOrphans(Query query) {
        if (this.orphans == null) {
            return query;
        }
        BooleanQuery result = new BooleanQuery();
        result.add(this.injectOrphans(query), BooleanClause.Occur.SHOULD);
        result.add((Query)new TermQuery(new Term(ORPHANS_KEY, ORPHANS_VALUE)), BooleanClause.Occur.SHOULD);
        return result;
    }

    private Query injectOrphans(Query query) {
        if (query instanceof BooleanQuery) {
            BooleanQuery source = (BooleanQuery)query;
            BooleanQuery result = new BooleanQuery();
            for (BooleanClause clause : source.clauses()) {
                result.add(this.injectOrphans(clause.getQuery()), clause.getOccur());
            }
            return result;
        }
        String orphanField = this.extractTermField(query);
        if (orphanField == null) {
            return query;
        }
        BooleanQuery result = new BooleanQuery();
        result.add(query, BooleanClause.Occur.SHOULD);
        result.add((Query)new TermQuery(new Term(ORPHANS_KEY, orphanField)), BooleanClause.Occur.SHOULD);
        return result;
    }

    private String extractTermField(Query query) {
        if (query instanceof TermQuery) {
            return ((TermQuery)query).getTerm().field();
        }
        if (query instanceof WildcardQuery) {
            return ((WildcardQuery)query).getTerm().field();
        }
        if (query instanceof PrefixQuery) {
            return ((PrefixQuery)query).getPrefix().field();
        }
        if (query instanceof MatchAllDocsQuery) {
            return null;
        }
        String field = this.getFieldFromExtractTerms(query);
        if (field != null) {
            return field;
        }
        return this.getFieldViaReflection(query);
    }

    private String getFieldViaReflection(Query query) {
        try {
            try {
                Term term = (Term)query.getClass().getMethod("getTerm", new Class[0]).invoke((Object)query, new Object[0]);
                return term.field();
            }
            catch (NoSuchMethodException e) {
                return (String)query.getClass().getMethod("getField", new Class[0]).invoke((Object)query, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getFieldFromExtractTerms(Query query) {
        HashSet terms = new HashSet();
        try {
            query.extractTerms(terms);
        }
        catch (UnsupportedOperationException e) {
            try {
                query.rewrite(this.reader).extractTerms(terms);
            }
            catch (IOException ioe) {
                throw new UnsupportedOperationException(ioe);
            }
            catch (UnsupportedOperationException ue) {
                // empty catch block
            }
        }
        return terms.isEmpty() ? null : ((Term)terms.iterator().next()).field();
    }

    @Override
    void close() {
        FullTxData.safeClose(this.writer);
        FullTxData.safeClose(this.reader);
        FullTxData.safeClose(this.searcher);
    }

    private void invalidateSearcher() {
        this.modified = true;
    }

    private IndexSearcher searcher(boolean allowRefreshSearcher) {
        if (!(this.searcher == null || this.modified && allowRefreshSearcher)) {
            return this.searcher;
        }
        try {
            IndexReader newReader;
            IndexReader indexReader = newReader = this.reader == null ? IndexReader.open((IndexWriter)this.writer, (boolean)true) : this.reader.reopen();
            if (newReader == this.reader) {
                IndexSearcher indexSearcher = this.searcher;
                return indexSearcher;
            }
            FullTxData.safeClose(this.reader);
            this.reader = newReader;
            FullTxData.safeClose(this.searcher);
            this.searcher = new IndexSearcher(this.reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (allowRefreshSearcher) {
                this.modified = false;
            }
        }
        return this.searcher;
    }

    private static void safeClose(Object object) {
        if (object == null) {
            return;
        }
        try {
            if (object instanceof IndexWriter) {
                ((IndexWriter)object).close();
            } else if (object instanceof IndexSearcher) {
                ((IndexSearcher)object).close();
            } else if (object instanceof IndexReader) {
                ((IndexReader)object).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    IndexSearcher asSearcher(TxDataHolder holder, QueryContext context) {
        boolean refresh = context == null || !context.getTradeCorrectnessForSpeed();
        return this.searcher(refresh);
    }

    @Override
    Collection<Long> get(TxDataHolder holder, String key, Object value) {
        return this.internalQuery(this.index.type.get(key, value), null);
    }

    @Override
    Collection<Long> getOrphans(String key) {
        return Collections.emptyList();
    }
}

