/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.impl.nioneo.xa.command.LogHandler;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;

public class LuceneLogTranslator
implements Function<List<LogEntry>, List<LogEntry>> {
    public List<LogEntry> apply(List<LogEntry> logEntries) {
        final ArrayList<LogEntry> newEntries = new ArrayList<LogEntry>();
        for (LogEntry logEntry : logEntries) {
            try {
                logEntry.accept((LogHandler)new LogHandler.Filter(null){

                    public void startEntry(LogEntry.Start startEntry) throws IOException {
                        newEntries.add(new LogEntry.Start(startEntry.getXid(), startEntry.getIdentifier(), -1, startEntry.getMasterId(), startEntry.getStartPosition(), startEntry.getTimeWritten(), startEntry.getLastCommittedTxWhenTransactionStarted()));
                    }

                    public void prepareEntry(LogEntry.Prepare prepareEntry) throws IOException {
                        newEntries.add(new LogEntry.Prepare(prepareEntry.getIdentifier(), -1, prepareEntry.getTimeWritten()));
                    }

                    public void onePhaseCommitEntry(LogEntry.OnePhaseCommit onePhaseCommitEntry) throws IOException {
                        newEntries.add(new LogEntry.OnePhaseCommit(onePhaseCommitEntry.getIdentifier(), -1, onePhaseCommitEntry.getTxId(), onePhaseCommitEntry.getTimeWritten()));
                    }

                    public void twoPhaseCommitEntry(LogEntry.TwoPhaseCommit twoPhaseCommitEntry) throws IOException {
                        newEntries.add(new LogEntry.TwoPhaseCommit(twoPhaseCommitEntry.getIdentifier(), -1, twoPhaseCommitEntry.getTxId(), twoPhaseCommitEntry.getTimeWritten()));
                    }

                    public void doneEntry(LogEntry.Done doneEntry) throws IOException {
                        newEntries.add(new LogEntry.Done(doneEntry.getIdentifier(), -1));
                    }

                    public void commandEntry(LogEntry.Command commandEntry) throws IOException {
                        newEntries.add(new LogEntry.Command(commandEntry.getIdentifier(), -1, commandEntry.getXaCommand()));
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return newEntries;
    }
}

