/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import org.neo4j.index.impl.lucene.EntityType;

class IndexIdentifier {
    final String indexName;
    final EntityType entityType;
    final byte entityTypeByte;
    private final int hashCode;

    public IndexIdentifier(byte entityTypeByte, EntityType entityType, String indexName) {
        this.entityTypeByte = entityTypeByte;
        this.entityType = entityType;
        this.indexName = indexName;
        this.hashCode = this.calculateHashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        IndexIdentifier i = (IndexIdentifier)o;
        return this.entityTypeByte == i.entityTypeByte && this.indexName.equals(i.indexName);
    }

    private int calculateHashCode() {
        int code = 17;
        code += 7 * this.entityTypeByte;
        return code += 7 * this.indexName.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "Index[" + this.indexName + "," + (this.entityTypeByte == 1 ? "Node" : "Relationship") + "]";
    }
}

