/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterStatus;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.index.LuceneIndexAccessor;
import org.neo4j.kernel.api.impl.index.LuceneIndexWriterFactory;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.UniquePropertyIndexUpdater;

class UniqueLuceneIndexAccessor
extends LuceneIndexAccessor {
    public UniqueLuceneIndexAccessor(LuceneDocumentStructure documentStructure, LuceneIndexWriterFactory indexWriterFactory, IndexWriterStatus writerStatus, DirectoryFactory dirFactory, File dirFile) throws IOException {
        super(documentStructure, indexWriterFactory, writerStatus, dirFactory, dirFile);
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        if (mode != IndexUpdateMode.RECOVERY) {
            return new LuceneUniquePropertyIndexUpdater(super.newUpdater(mode));
        }
        return super.newUpdater(mode);
    }

    private class LuceneUniquePropertyIndexUpdater
    extends UniquePropertyIndexUpdater {
        final IndexUpdater delegate;

        public LuceneUniquePropertyIndexUpdater(IndexUpdater delegate) {
            this.delegate = delegate;
        }

        protected void flushUpdates(Iterable<NodePropertyUpdate> updates) throws IOException, IndexEntryConflictException {
            for (NodePropertyUpdate update : updates) {
                this.delegate.process(update);
            }
            this.delegate.close();
        }

        public void remove(Iterable<Long> nodeIds) throws IOException {
            this.delegate.remove(nodeIds);
        }
    }
}

