/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.index.impl.lucene.CommitContext;
import org.neo4j.index.impl.lucene.EntityType;
import org.neo4j.index.impl.lucene.IndexIdentifier;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.index.impl.lucene.RelationshipId;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;

abstract class LuceneCommand
extends XaCommand {
    private static final byte ADD_COMMAND = 1;
    private static final byte REMOVE_COMMAND = 2;
    private static final byte DELETE_COMMAND = 3;
    private static final byte CREATE_INDEX_COMMAND = 4;
    public static final byte NODE = 1;
    public static final byte RELATIONSHIP = 2;
    private static final byte VALUE_TYPE_NULL = 0;
    private static final byte VALUE_TYPE_INT = 1;
    private static final byte VALUE_TYPE_LONG = 2;
    private static final byte VALUE_TYPE_FLOAT = 3;
    private static final byte VALUE_TYPE_DOUBLE = 4;
    private static final byte VALUE_TYPE_STRING = 5;
    final IndexIdentifier indexId;
    final Object entityId;
    final String key;
    final Object value;
    final byte type;
    final byte entityType;

    LuceneCommand(IndexIdentifier indexId, byte entityType, Object entityId, String key, Object value, byte type) {
        assert (entityType == 1 || entityType == 2);
        this.indexId = indexId;
        this.entityType = entityType;
        this.entityId = entityId;
        this.key = key;
        this.value = value;
        this.type = type;
    }

    public void execute() {
    }

    abstract void perform(CommitContext var1);

    public Class<? extends PropertyContainer> getEntityType() {
        if (this.entityType == 1) {
            return Node.class;
        }
        if (this.entityType == 2) {
            return Relationship.class;
        }
        throw new IllegalArgumentException("Unknown entity type " + this.entityType);
    }

    public void writeToFile(LogBuffer buffer) throws IOException {
        buffer.put(this.type);
        buffer.put(this.entityType);
        char[] indexName = this.indexId.indexName.toCharArray();
        buffer.putInt(indexName.length);
        long id = this.entityId instanceof Long ? (Long)this.entityId : ((RelationshipId)this.entityId).id;
        buffer.putLong(id);
        char[] key = this.key == null ? null : this.key.toCharArray();
        buffer.putInt(key == null ? -1 : key.length);
        int valueType = 0;
        valueType = this.value == null ? 0 : (this.value instanceof Number ? (this.value instanceof Float ? 3 : (this.value instanceof Double ? 4 : (this.value instanceof Long ? 2 : 1))) : 5);
        buffer.put((byte)valueType);
        buffer.put(indexName);
        if (key != null) {
            buffer.put(key);
        }
        if (valueType == 5) {
            char[] charValue = this.value.toString().toCharArray();
            buffer.putInt(charValue.length);
            buffer.put(charValue);
        } else if (valueType != 0) {
            Number number = (Number)this.value;
            switch (valueType) {
                case 3: {
                    buffer.putInt(Float.floatToRawIntBits(number.floatValue()));
                    break;
                }
                case 4: {
                    buffer.putLong(Double.doubleToRawLongBits(number.doubleValue()));
                    break;
                }
                case 2: {
                    buffer.putLong(number.longValue());
                    break;
                }
                case 1: {
                    buffer.putInt(number.intValue());
                    break;
                }
                default: {
                    throw new Error("Should not reach here.");
                }
            }
        }
    }

    public abstract boolean isConsideredNormalWriteCommand();

    private static void writeLengthAndString(LogBuffer buffer, String string) throws IOException {
        char[] chars = string.toCharArray();
        buffer.putInt(chars.length);
        buffer.put(chars);
    }

    static XaCommand readCommand(ReadableByteChannel channel, ByteBuffer buffer, LuceneDataSource dataSource) throws IOException {
        buffer.clear();
        buffer.limit(2);
        if (channel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        byte commandType = buffer.get();
        byte entityTypeByte = buffer.get();
        if (commandType == 4) {
            buffer.clear();
            String name = IoPrimitiveUtils.readLengthAndString((ReadableByteChannel)channel, (ByteBuffer)buffer);
            if (name == null) {
                return null;
            }
            int size = IoPrimitiveUtils.readInt((ReadableByteChannel)channel, (ByteBuffer)buffer);
            HashMap<String, String> config = new HashMap<String, String>();
            for (int i = 0; i < size; ++i) {
                String key = IoPrimitiveUtils.readLengthAndString((ReadableByteChannel)channel, (ByteBuffer)buffer);
                String value = IoPrimitiveUtils.readLengthAndString((ReadableByteChannel)channel, (ByteBuffer)buffer);
                if (key == null || value == null) {
                    return null;
                }
                config.put(key, value);
            }
            return new CreateIndexCommand(entityTypeByte, name, config);
        }
        buffer.clear();
        buffer.limit(17);
        if (channel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        EntityType entityType = null;
        if (entityTypeByte == 1) {
            entityType = dataSource.nodeEntityType;
        } else if (entityTypeByte == 2) {
            entityType = dataSource.relationshipEntityType;
        } else {
            return null;
        }
        int indexNameLength = buffer.getInt();
        long entityId = buffer.getLong();
        int keyCharLength = buffer.getInt();
        byte valueType = buffer.get();
        String indexName = IoPrimitiveUtils.readString((ReadableByteChannel)channel, (ByteBuffer)buffer, (int)indexNameLength);
        if (indexName == null) {
            return null;
        }
        String key = null;
        if (keyCharLength != -1 && (key = IoPrimitiveUtils.readString((ReadableByteChannel)channel, (ByteBuffer)buffer, (int)keyCharLength)) == null) {
            return null;
        }
        Object value = null;
        if (valueType >= 1 && valueType <= 4) {
            switch (valueType) {
                case 1: {
                    value = IoPrimitiveUtils.readInt((ReadableByteChannel)channel, (ByteBuffer)buffer);
                    break;
                }
                case 2: {
                    value = IoPrimitiveUtils.readLong((ReadableByteChannel)channel, (ByteBuffer)buffer);
                    break;
                }
                case 3: {
                    value = IoPrimitiveUtils.readFloat((ReadableByteChannel)channel, (ByteBuffer)buffer);
                    break;
                }
                case 4: {
                    value = IoPrimitiveUtils.readDouble((ReadableByteChannel)channel, (ByteBuffer)buffer);
                }
            }
        } else if (valueType == 5) {
            value = IoPrimitiveUtils.readLengthAndString((ReadableByteChannel)channel, (ByteBuffer)buffer);
        }
        if (valueType != 0 && value == null) {
            return null;
        }
        Long startNodeId = null;
        Long endNodeId = null;
        if (commandType == 1 && entityTypeByte == 2) {
            startNodeId = IoPrimitiveUtils.readLong((ReadableByteChannel)channel, (ByteBuffer)buffer);
            endNodeId = IoPrimitiveUtils.readLong((ReadableByteChannel)channel, (ByteBuffer)buffer);
            if (startNodeId == null || endNodeId == null) {
                return null;
            }
        }
        IndexIdentifier identifier = new IndexIdentifier(entityTypeByte, entityType, indexName);
        switch (commandType) {
            case 1: {
                return entityTypeByte == 1 ? new AddCommand(identifier, entityTypeByte, entityId, key, value) : new AddRelationshipCommand(identifier, entityTypeByte, new RelationshipId(entityId, startNodeId, endNodeId), key, value);
            }
            case 2: {
                return new RemoveCommand(identifier, entityTypeByte, entityId, key, value);
            }
            case 3: {
                return new DeleteCommand(identifier);
            }
        }
        throw new IOException("Unknown command type[" + commandType + "]");
    }

    static class CreateIndexCommand
    extends LuceneCommand {
        static final IndexIdentifier FAKE_IDENTIFIER = new IndexIdentifier(9, null, "create index");
        private final String name;
        private final Map<String, String> config;

        CreateIndexCommand(byte entityType, String name, Map<String, String> config) {
            super(FAKE_IDENTIFIER, entityType, -1L, null, null, (byte)4);
            this.name = name;
            this.config = config;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getConfig() {
            return this.config;
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            buffer.put(this.type);
            buffer.put(this.entityType);
            LuceneCommand.writeLengthAndString(buffer, this.name);
            buffer.putInt(this.config.size());
            for (Map.Entry<String, String> entry : this.config.entrySet()) {
                LuceneCommand.writeLengthAndString(buffer, entry.getKey());
                LuceneCommand.writeLengthAndString(buffer, entry.getValue());
            }
        }

        @Override
        void perform(CommitContext context) {
            context.dataSource.indexStore.setIfNecessary(this.getEntityType(), this.name, this.config);
        }

        @Override
        public boolean isConsideredNormalWriteCommand() {
            return false;
        }
    }

    static class DeleteCommand
    extends LuceneCommand {
        DeleteCommand(IndexIdentifier indexId) {
            super(indexId, indexId.entityTypeByte, -1L, "", "", (byte)3);
        }

        @Override
        void perform(CommitContext context) {
            context.documents.clear();
            context.dataSource.deleteIndex(context.identifier, context.recovery);
        }

        @Override
        public boolean isConsideredNormalWriteCommand() {
            return false;
        }
    }

    static class RemoveCommand
    extends LuceneCommand {
        RemoveCommand(IndexIdentifier indexId, byte entityType, Object entityId, String key, Object value) {
            super(indexId, entityType, entityId, key, value, (byte)2);
        }

        @Override
        void perform(CommitContext context) {
            context.ensureWriterInstantiated();
            CommitContext.DocumentContext document = context.getDocument(this.entityId, false);
            if (document != null) {
                context.indexType.removeFromDocument(document.document, this.key, this.value);
                context.dataSource.invalidateCache(context.identifier, this.key, this.value);
            }
        }

        @Override
        public boolean isConsideredNormalWriteCommand() {
            return true;
        }
    }

    static class AddRelationshipCommand
    extends LuceneCommand {
        AddRelationshipCommand(IndexIdentifier indexId, byte entityType, RelationshipId entityId, String key, Object value) {
            super(indexId, entityType, entityId, key, value, (byte)1);
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            super.writeToFile(buffer);
            buffer.putLong(((RelationshipId)this.entityId).startNode);
            buffer.putLong(((RelationshipId)this.entityId).endNode);
        }

        @Override
        void perform(CommitContext context) {
            context.ensureWriterInstantiated();
            context.indexType.addToDocument(context.getDocument((Object)this.entityId, (boolean)true).document, this.key, this.value);
            context.dataSource.invalidateCache(context.identifier, this.key, this.value);
        }

        @Override
        public boolean isConsideredNormalWriteCommand() {
            return true;
        }
    }

    static class AddCommand
    extends LuceneCommand {
        AddCommand(IndexIdentifier indexId, byte entityType, Object entityId, String key, Object value) {
            super(indexId, entityType, entityId, key, value, (byte)1);
        }

        @Override
        void perform(CommitContext context) {
            context.ensureWriterInstantiated();
            context.indexType.addToDocument(context.getDocument((Object)this.entityId, (boolean)true).document, this.key, this.value);
            context.dataSource.invalidateCache(context.identifier, this.key, this.value);
        }

        @Override
        public boolean isConsideredNormalWriteCommand() {
            return true;
        }
    }
}

