/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.BatchInserterIndex;
import org.neo4j.graphdb.index.BatchInserterIndexProvider;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.impl.lucene.EntityType;
import org.neo4j.index.impl.lucene.IndexIdentifier;
import org.neo4j.index.impl.lucene.IndexType;
import org.neo4j.index.impl.lucene.LuceneBatchInserterIndex;
import org.neo4j.index.impl.lucene.RelationshipId;
import org.neo4j.kernel.impl.batchinsert.BatchInserter;
import org.neo4j.kernel.impl.batchinsert.BatchInserterImpl;
import org.neo4j.kernel.impl.batchinsert.SimpleRelationship;
import org.neo4j.kernel.impl.index.IndexStore;

public class LuceneBatchInserterIndexProvider
implements BatchInserterIndexProvider {
    private final BatchInserter inserter;
    private final Map<IndexIdentifier, LuceneBatchInserterIndex> indexes = new HashMap<IndexIdentifier, LuceneBatchInserterIndex>();
    final IndexStore indexStore;
    final EntityType nodeEntityType;
    final EntityType relationshipEntityType;

    public LuceneBatchInserterIndexProvider(final BatchInserter inserter) {
        this.inserter = inserter;
        this.indexStore = ((BatchInserterImpl)inserter).getIndexStore();
        this.nodeEntityType = new EntityType(){

            @Override
            public Document newDocument(Object entityId) {
                return IndexType.newBaseDocument((Long)entityId);
            }

            @Override
            public Class<? extends PropertyContainer> getType() {
                return Node.class;
            }
        };
        this.relationshipEntityType = new EntityType(){

            @Override
            public Document newDocument(Object entityId) {
                RelationshipId relId = null;
                if (entityId instanceof Long) {
                    SimpleRelationship relationship = inserter.getRelationshipById(((Long)entityId).longValue());
                    relId = new RelationshipId(relationship.getId(), relationship.getStartNode(), relationship.getEndNode());
                } else if (entityId instanceof RelationshipId) {
                    relId = (RelationshipId)entityId;
                } else {
                    new IllegalArgumentException("Ids of type " + entityId.getClass() + " are not supported.");
                }
                Document doc = IndexType.newBaseDocument(relId.id);
                doc.add((Fieldable)new Field("_start_node_id_", "" + relId.startNode, Field.Store.YES, Field.Index.NOT_ANALYZED));
                doc.add((Fieldable)new Field("_end_node_id_", "" + relId.endNode, Field.Store.YES, Field.Index.NOT_ANALYZED));
                return doc;
            }

            @Override
            public Class<? extends PropertyContainer> getType() {
                return Relationship.class;
            }
        };
    }

    public BatchInserterIndex nodeIndex(String indexName, Map<String, String> config) {
        this.config(Node.class, indexName, config);
        return this.index(new IndexIdentifier(1, this.nodeEntityType, indexName), config);
    }

    private Map<String, String> config(Class<? extends PropertyContainer> cls, String indexName, Map<String, String> config) {
        if (config != null) {
            config = MapUtil.stringMap(new HashMap<String, String>(config), (String[])new String[]{"provider", "lucene"});
            this.indexStore.setIfNecessary(cls, indexName, config);
            return config;
        }
        return this.indexStore.get(cls, indexName);
    }

    public BatchInserterIndex relationshipIndex(String indexName, Map<String, String> config) {
        this.config(Relationship.class, indexName, config);
        return this.index(new IndexIdentifier(2, this.relationshipEntityType, indexName), config);
    }

    private BatchInserterIndex index(IndexIdentifier identifier, Map<String, String> config) {
        LuceneBatchInserterIndex index = this.indexes.get(identifier);
        if (index == null) {
            index = new LuceneBatchInserterIndex(this, this.inserter, identifier, config);
            this.indexes.put(identifier, index);
        }
        return index;
    }

    public void shutdown() {
        for (LuceneBatchInserterIndex index : this.indexes.values()) {
            index.shutdown();
        }
    }
}

