/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.event;

import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.event.EventPublisher;
import org.neo4j.logging.event.Parameters;
import org.neo4j.logging.event.Type;
import org.neo4j.logging.internal.PrefixedLogProvider;
import org.neo4j.util.VisibleForTesting;

class LoggingEventPublisher
implements EventPublisher {
    private final Log log;

    LoggingEventPublisher(InternalLogProvider logProvider, String description) {
        this(new PrefixedLogProvider(logProvider, "Event").getLog(description));
    }

    @VisibleForTesting
    LoggingEventPublisher(Log log) {
        this.log = log;
    }

    @Override
    public void publish(Type type, String message, Parameters parameters) {
        switch (type) {
            case Begin: 
            case Finish: {
                this.log.info("%s - %s %s", new Object[]{type, message, parameters});
                break;
            }
            case Info: {
                this.log.info("%s - %s", message, parameters);
                break;
            }
            case Warn: {
                this.log.warn("%s - %s", message, parameters);
                break;
            }
            case Error: {
                this.log.error("%s - %s", message, parameters);
            }
        }
    }

    @Override
    public void publish(Type type, String message) {
        this.publish(type, message, Parameters.EMPTY);
    }
}

