/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.event;

import org.neo4j.logging.event.EventPublisher;
import org.neo4j.logging.event.EventsFilter;
import org.neo4j.logging.event.Parameters;
import org.neo4j.logging.event.Type;

class CappedEventPublisher
implements EventPublisher {
    private final EventPublisher delegate;
    private final EventsFilter filter;

    private CappedEventPublisher(EventPublisher delegate, EventsFilter filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    static CappedEventPublisher capped(EventPublisher delegate, EventsFilter filter) {
        return new CappedEventPublisher(delegate, filter);
    }

    @Override
    public void publish(Type type, String message, Parameters parameters) {
        if (this.filter.canPublish()) {
            this.delegate.publish(type, message, parameters);
        }
    }

    @Override
    public void publish(Type type, String message) {
        if (this.filter.canPublish()) {
            this.delegate.publish(type, message);
        }
    }
}

