/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Objects;
import org.apache.logging.log4j.core.util.NullOutputStream;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.Level;

public class LoggerPrintStreamAdaptor
extends PrintStream {
    private final InternalLog log;
    private final Level level;

    public LoggerPrintStreamAdaptor(InternalLog log, Level level) {
        super((OutputStream)NullOutputStream.getInstance());
        this.level = Objects.requireNonNull(level);
        this.log = Objects.requireNonNull(log);
    }

    @Override
    public void print(boolean m) {
        this.log(String.valueOf(m));
    }

    @Override
    public void print(char m) {
        this.log(String.valueOf(m));
    }

    @Override
    public void print(char[] m) {
        this.log(String.valueOf(m));
    }

    @Override
    public void print(double m) {
        this.log(String.valueOf(m));
    }

    @Override
    public void print(float m) {
        this.log(String.valueOf(m));
    }

    @Override
    public void print(int m) {
        this.log(String.valueOf(m));
    }

    @Override
    public void print(long m) {
        this.log(String.valueOf(m));
    }

    @Override
    public void print(Object m) {
        this.log(String.valueOf(m));
    }

    @Override
    public void print(String m) {
        this.log(String.valueOf(m));
    }

    @Override
    public void println() {
    }

    @Override
    public void println(boolean m) {
        this.log(String.valueOf(m));
    }

    @Override
    public void println(char m) {
        this.log(String.valueOf(m));
    }

    @Override
    public void println(char[] m) {
        this.log(String.valueOf(m));
    }

    @Override
    public void println(double m) {
        this.log(String.valueOf(m));
    }

    @Override
    public void println(float m) {
        this.log(String.valueOf(m));
    }

    @Override
    public void println(int m) {
        this.log(String.valueOf(m));
    }

    @Override
    public void println(long m) {
        this.log(String.valueOf(m));
    }

    @Override
    public void println(Object m) {
        this.log(String.valueOf(m));
    }

    @Override
    public void println(String m) {
        this.log(m);
    }

    @Override
    public PrintStream printf(String s, Object ... args) {
        this.log(s, args);
        return this;
    }

    private void log(String s, Object ... args) {
        s = s.strip();
        switch (this.level) {
            case INFO: {
                this.log.info(s, args);
                break;
            }
            case ERROR: {
                this.log.error(s, args);
                break;
            }
            case WARN: {
                this.log.warn(s, args);
                break;
            }
            case DEBUG: {
                this.log.debug(s, args);
            }
        }
    }

    private void log(String s) {
        s = s.strip();
        switch (this.level) {
            case INFO: {
                this.log.info(s);
                break;
            }
            case ERROR: {
                this.log.error(s);
                break;
            }
            case WARN: {
                this.log.warn(s);
                break;
            }
            case DEBUG: {
                this.log.debug(s);
            }
        }
    }
}

