/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.log4j;

import org.neo4j.logging.log4j.Neo4jConfiguration;
import org.neo4j.logging.log4j.Neo4jLogLayout;
import org.neo4j.logging.log4j.StructureAwareMessage;
import org.neo4j.logging.shaded.log4j.core.LogEvent;
import org.neo4j.logging.shaded.log4j.core.config.plugins.Plugin;
import org.neo4j.logging.shaded.log4j.core.config.plugins.PluginAttribute;
import org.neo4j.logging.shaded.log4j.core.config.plugins.PluginFactory;
import org.neo4j.logging.shaded.log4j.core.pattern.DatePatternConverter;
import org.neo4j.logging.shaded.log4j.core.pattern.NameAbbreviator;
import org.neo4j.logging.shaded.log4j.core.pattern.ThrowablePatternConverter;
import org.neo4j.logging.shaded.log4j.message.Message;
import org.neo4j.logging.shaded.log4j.util.StringBuilderFormattable;
import org.neo4j.logging.shaded.log4j.util.StringBuilders;

@Plugin(name="Neo4jJsonLogLayout", category="Core", elementType="layout", printObject=true)
public class Neo4jJsonLogLayout
extends Neo4jLogLayout {
    private final DatePatternConverter datePatternConverter;
    private final ThrowablePatternConverter throwablePatternConverter;
    private final NameAbbreviator abbreviator;
    private final boolean includeCategory;

    protected Neo4jJsonLogLayout(String datePattern, String timeZone, boolean includeCategory, Neo4jConfiguration config) {
        super("", config);
        this.includeCategory = includeCategory;
        this.datePatternConverter = DatePatternConverter.newInstance(new String[]{datePattern, timeZone});
        this.throwablePatternConverter = ThrowablePatternConverter.newInstance(config, null);
        this.abbreviator = NameAbbreviator.getAbbreviator("1.");
    }

    @PluginFactory
    public static Neo4jJsonLogLayout createLayout(@PluginAttribute(value="datePattern") String datePattern, @PluginAttribute(value="timeZone") String timeZone, @PluginAttribute(value="includeCategory", defaultBoolean=true) boolean includeCategory) {
        return new Neo4jJsonLogLayout(datePattern, timeZone, includeCategory, new Neo4jConfiguration());
    }

    @Override
    public String toSerializable(LogEvent event) {
        Message message;
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("{\"time\":\"");
        this.datePatternConverter.format(event, buffer);
        buffer.append("\",\"level\":\"");
        buffer.append(event.getLevel().toString());
        buffer.append('\"');
        if (this.includeCategory) {
            buffer.append(",\"category\":\"");
            this.abbreviator.abbreviate(event.getLoggerName(), buffer);
            buffer.append('\"');
        }
        if ((message = event.getMessage()) instanceof StructureAwareMessage) {
            StructureAwareMessage msg = (StructureAwareMessage)message;
            msg.asStructure(new JsonFieldConsumer(buffer));
        } else {
            buffer.append(",\"message\":\"");
            int start = buffer.length();
            if (message instanceof StringBuilderFormattable) {
                ((StringBuilderFormattable)((Object)message)).formatTo(buffer);
            } else {
                buffer.append(message.getFormattedMessage());
            }
            StringBuilders.escapeJson(buffer, start);
            buffer.append('\"');
        }
        if (event.getThrown() != null) {
            buffer.append(",\"stacktrace\":\"");
            int start = buffer.length();
            this.throwablePatternConverter.format(event, buffer);
            StringBuilders.escapeJson(buffer, start);
            buffer.append('\"');
        }
        buffer.append('}').append(System.lineSeparator());
        return buffer.toString();
    }

    private static class JsonFieldConsumer
    implements StructureAwareMessage.FieldConsumer {
        private final StringBuilder buffer;

        private JsonFieldConsumer(StringBuilder buffer) {
            this.buffer = buffer;
        }

        @Override
        public void add(String field, String value) {
            JsonFieldConsumer.addField(this.buffer, field);
            JsonFieldConsumer.formatString(this.buffer, value);
        }

        @Override
        public void add(String field, long value) {
            JsonFieldConsumer.addField(this.buffer, field);
            this.buffer.append(value);
        }

        private static void addField(StringBuilder buffer, String field) {
            buffer.append(",\"").append(field).append("\":");
        }

        private static void formatString(StringBuilder buffer, Object value) {
            buffer.append('\"');
            int startIndex = buffer.length();
            buffer.append(value);
            StringBuilders.escapeJson(buffer, startIndex);
            buffer.append('\"');
        }
    }
}

