/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.PrintWriter;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.neo4j.logging.AbstractPrintWriterLogger;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.FormattedLoggerJson;
import org.neo4j.logging.FormattedLoggerStandard;
import org.neo4j.logging.Level;

public enum FormattedLogFormat {
    STANDARD_FORMAT,
    JSON_FORMAT;


    public static AbstractPrintWriterLogger getFormattedLogger(FormattedLogFormat format, FormattedLog formattedLog, @Nonnull Supplier<PrintWriter> writerSupplier, @Nonnull Level level, String category, DateTimeFormatter dateTimeFormatter, Supplier<ZonedDateTime> zonedDateTimeSupplier) {
        switch (format) {
            case JSON_FORMAT: {
                return new FormattedLoggerJson(formattedLog, writerSupplier, level, category, dateTimeFormatter, zonedDateTimeSupplier);
            }
        }
        return new FormattedLoggerStandard(formattedLog, writerSupplier, level, category, dateTimeFormatter, zonedDateTimeSupplier);
    }
}

