/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.PrintStream;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.neo4j.logging.Logger;

public class PrintStreamLogger
implements Logger {
    private PrintStream printStream;

    public PrintStreamLogger(PrintStream printStream) {
        this.printStream = printStream;
    }

    @Override
    public void log(@Nonnull String message) {
        this.printStream.println(message);
    }

    @Override
    public void log(@Nonnull String message, @Nonnull Throwable throwable) {
        this.printStream.printf("%s, cause: %s%n", message, throwable);
    }

    @Override
    public void log(@Nonnull String format, Object ... arguments) {
        this.printStream.printf(format, arguments);
        this.printStream.println();
    }

    @Override
    public void bulk(@Nonnull Consumer<Logger> consumer) {
        Objects.requireNonNull(consumer);
        consumer.accept(this);
    }
}

