/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public abstract class AbstractLogProvider<T extends Log>
implements LogProvider {
    private final ConcurrentHashMap<String, LogWithContext> logCache = new ConcurrentHashMap();
    private final ReadWriteLock settingsChangeLock = new ReentrantReadWriteLock();

    public T getLog(Class<?> loggingClass) {
        return (T)this.getLog(loggingClass.getName(), () -> this.buildLog(loggingClass));
    }

    public T getLog(String name) {
        return (T)this.getLog(name, () -> this.buildLog(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getLog(String name, Supplier<T> logSupplier) {
        LogWithContext log = this.logCache.get(name);
        if (log == null) {
            this.settingsChangeLock.readLock().lock();
            try {
                log = this.logCache.computeIfAbsent(name, c -> new LogWithContext(this, (Log)logSupplier.get(), c));
            }
            finally {
                this.settingsChangeLock.readLock().unlock();
            }
        }
        return log.log;
    }

    protected Collection<T> cachedLogs() {
        return this.logCache.values().stream().map(logWithContext -> logWithContext.log).collect(Collectors.toList());
    }

    protected abstract T buildLog(Class<?> var1);

    protected abstract T buildLog(String var1);

    void makeDynamicSettingsChange(Runnable change, BiConsumer<T, String> logInstanceRefresher) {
        this.settingsChangeLock.writeLock().lock();
        try {
            change.run();
            this.logCache.values().forEach(log -> logInstanceRefresher.accept(log.log, log.fullContext));
        }
        finally {
            this.settingsChangeLock.writeLock().unlock();
        }
    }

    private static class LogWithContext {
        private final T log;
        private final String fullContext;
        final /* synthetic */ AbstractLogProvider this$0;

        LogWithContext(T log, String fullContext) {
            this.this$0 = var1_1;
            this.log = log;
            this.fullContext = fullContext;
        }
    }
}

