/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.async;

import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.neo4j.concurrent.AsyncEvent;
import org.neo4j.concurrent.AsyncEventSender;
import org.neo4j.logging.AbstractLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;
import org.neo4j.logging.async.AsyncLogEvent;

public class AsyncLog
extends AbstractLog {
    private final Log log;
    private final AsyncEventSender<AsyncLogEvent> events;

    public AsyncLog(@Nonnull AsyncEventSender<AsyncLogEvent> events, @Nonnull Log log) {
        this.log = Objects.requireNonNull(log, "Log");
        this.events = Objects.requireNonNull(events, "AsyncEventSender<AsyncLogEvent>");
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    @Nonnull
    public Logger debugLogger() {
        return new AsyncLogger(this.events, this.log.debugLogger());
    }

    @Override
    @Nonnull
    public Logger infoLogger() {
        return new AsyncLogger(this.events, this.log.infoLogger());
    }

    @Override
    @Nonnull
    public Logger warnLogger() {
        return new AsyncLogger(this.events, this.log.warnLogger());
    }

    @Override
    @Nonnull
    public Logger errorLogger() {
        return new AsyncLogger(this.events, this.log.errorLogger());
    }

    @Override
    public void bulk(@Nonnull Consumer<Log> consumer) {
        this.events.send((AsyncEvent)AsyncLogEvent.bulkLogEvent(this.log, consumer));
    }

    private static class AsyncLogger
    implements Logger {
        private final Logger logger;
        private final AsyncEventSender<AsyncLogEvent> events;

        AsyncLogger(@Nonnull AsyncEventSender<AsyncLogEvent> events, @Nonnull Logger logger) {
            this.logger = Objects.requireNonNull(logger, "Logger");
            this.events = Objects.requireNonNull(events);
        }

        @Override
        public void log(@Nonnull String message) {
            this.events.send((AsyncEvent)AsyncLogEvent.logEvent(this.logger, message));
        }

        @Override
        public void log(@Nonnull String message, @Nonnull Throwable throwable) {
            Objects.requireNonNull(throwable);
            this.events.send((AsyncEvent)AsyncLogEvent.logEvent(this.logger, message, throwable));
        }

        @Override
        public void log(@Nonnull String format, Object ... arguments) {
            Objects.requireNonNull(arguments);
            this.events.send((AsyncEvent)AsyncLogEvent.logEvent(this.logger, format, arguments));
        }

        @Override
        public void bulk(@Nonnull Consumer<Logger> consumer) {
            this.events.send((AsyncEvent)AsyncLogEvent.bulkLogEvent(this.logger, consumer));
        }
    }
}

