/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.log4j;

import java.io.Closeable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.StringFormatterMessageFactory;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerContext;
import org.neo4j.io.IOUtils;

public class Neo4jLoggerContext
implements Closeable {
    private final LoggerContext ctx;
    private final Closeable additionalClosable;
    private final String configSourceInfo;

    public Neo4jLoggerContext(LoggerContext ctx, Closeable additionalClosable, String configSourceInfo) {
        this.ctx = ctx;
        this.additionalClosable = additionalClosable;
        this.configSourceInfo = configSourceInfo;
    }

    public ExtendedLogger getLogger(Class<?> clazz) {
        return this.ctx.getLogger(clazz, (MessageFactory)StringFormatterMessageFactory.INSTANCE);
    }

    ExtendedLogger getLogger(String name) {
        return this.ctx.getLogger(name, (MessageFactory)StringFormatterMessageFactory.INSTANCE);
    }

    LoggerContext getLoggerContext() {
        return this.ctx;
    }

    @Override
    public void close() {
        LogManager.shutdown((LoggerContext)this.ctx);
        if (this.additionalClosable != null) {
            IOUtils.closeAllSilently((AutoCloseable[])new AutoCloseable[]{this.additionalClosable});
        }
    }

    public String getConfigSourceInfo() {
        return this.configSourceInfo;
    }
}

