/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.log4j.LoggerTarget;

public abstract class AbstractLogProvider<T extends InternalLog>
implements InternalLogProvider {
    private final ConcurrentHashMap<String, LogWithContext> logCache = new ConcurrentHashMap();
    private final ReadWriteLock settingsChangeLock = new ReentrantReadWriteLock();

    public T getLog(Class<?> loggingClass) {
        return (T)this.getLog(loggingClass.getName(), () -> this.buildLog(loggingClass));
    }

    public T getLog(String name) {
        return (T)this.getLog(name, () -> this.buildLog(name));
    }

    public T getLog(LoggerTarget target) {
        String name = target.getTarget();
        return (T)this.getLog(name, () -> this.buildLog(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getLog(String name, Supplier<T> logSupplier) {
        LogWithContext log = this.logCache.get(name);
        if (log == null) {
            this.settingsChangeLock.readLock().lock();
            try {
                log = this.logCache.computeIfAbsent(name, c -> new LogWithContext(this, (InternalLog)logSupplier.get(), c));
            }
            finally {
                this.settingsChangeLock.readLock().unlock();
            }
        }
        return log.log;
    }

    protected abstract T buildLog(Class<?> var1);

    protected abstract T buildLog(String var1);

    private class LogWithContext {
        private final T log;
        private final String fullContext;

        /*
         * WARNING - Possible parameter corruption
         */
        LogWithContext(T log, String fullContext) {
            this.log = log;
            this.fullContext = fullContext;
        }
    }
}

