/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.function.LongSupplier;
import org.neo4j.function.Supplier;
import org.neo4j.io.file.Files;
import org.neo4j.io.fs.FileSystemAbstraction;

public class RotatingFileOutputStreamSupplier
implements Supplier<OutputStream>,
Closeable {
    private static final LongSupplier DEFAULT_CURRENT_TIME_SUPPLIER = new LongSupplier(){

        public long getAsLong() {
            return System.currentTimeMillis();
        }
    };
    private final LongSupplier currentTimeSupplier;
    private final FileSystemAbstraction fileSystem;
    private final File outputFile;
    private final long rotationThresholdBytes;
    private final long rotationDelaySeconds;
    private final int maxArchives;
    private final RotationListener rotationListener;
    private final Executor rotationExecutor;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean rotating = new AtomicBoolean(false);
    private final AtomicLong earliestRotationTimeRef = new AtomicLong(0L);
    private final AtomicReference<OutputStream> outRef = new AtomicReference();
    private final List<WeakReference<OutputStream>> archivedStreams = new LinkedList<WeakReference<OutputStream>>();

    public RotatingFileOutputStreamSupplier(FileSystemAbstraction fileSystem, File outputFile, long rotationThresholdBytes, int rotationDelaySeconds, int maxArchives, Executor rotationExecutor) throws IOException {
        this(fileSystem, outputFile, rotationThresholdBytes, rotationDelaySeconds, maxArchives, rotationExecutor, new RotationListener());
    }

    public RotatingFileOutputStreamSupplier(FileSystemAbstraction fileSystem, File outputFile, long rotationThresholdBytes, int rotationDelaySeconds, int maxArchives, Executor rotationExecutor, RotationListener rotationListener) throws IOException {
        this(DEFAULT_CURRENT_TIME_SUPPLIER, fileSystem, outputFile, rotationThresholdBytes, rotationDelaySeconds, maxArchives, rotationExecutor, rotationListener);
    }

    RotatingFileOutputStreamSupplier(LongSupplier currentTimeSupplier, FileSystemAbstraction fileSystem, File outputFile, long rotationThresholdBytes, int rotationDelaySeconds, int maxArchives, Executor rotationExecutor, RotationListener rotationListener) throws IOException {
        this.currentTimeSupplier = currentTimeSupplier;
        this.fileSystem = fileSystem;
        this.outputFile = outputFile;
        this.rotationThresholdBytes = rotationThresholdBytes;
        this.rotationDelaySeconds = TimeUnit.SECONDS.toMillis(rotationDelaySeconds);
        this.maxArchives = maxArchives;
        this.rotationListener = rotationListener;
        this.rotationExecutor = rotationExecutor;
        this.outRef.set(this.openOutputFile());
    }

    public OutputStream get() {
        if (!this.closed.get() && !this.rotating.get() && this.rotationDelayExceeded() && this.rotationThresholdExceeded()) {
            this.rotate();
        }
        return this.outRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        AtomicReference<OutputStream> atomicReference = this.outRef;
        synchronized (atomicReference) {
            this.closed.set(true);
            for (WeakReference<OutputStream> archivedStream : this.archivedStreams) {
                OutputStream outputStream = (OutputStream)archivedStream.get();
                if (outputStream == null) continue;
                try {
                    outputStream.close();
                }
                catch (Exception e) {}
            }
            this.outRef.get().close();
        }
    }

    private boolean rotationThresholdExceeded() {
        return this.rotationThresholdBytes == 0L || !this.fileSystem.fileExists(this.outputFile) || this.fileSystem.getFileSize(this.outputFile) >= this.rotationThresholdBytes;
    }

    private boolean rotationDelayExceeded() {
        return this.earliestRotationTimeRef.get() <= this.currentTimeSupplier.getAsLong();
    }

    private void rotate() {
        if (this.rotating.getAndSet(true)) {
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OutputStream newStream;
                try {
                    if (RotatingFileOutputStreamSupplier.this.fileSystem.fileExists(RotatingFileOutputStreamSupplier.this.outputFile)) {
                        RotatingFileOutputStreamSupplier.this.shiftArchivedOutputFiles();
                        RotatingFileOutputStreamSupplier.this.fileSystem.renameFile(RotatingFileOutputStreamSupplier.this.outputFile, RotatingFileOutputStreamSupplier.this.archivedOutputFile(1));
                    }
                    newStream = RotatingFileOutputStreamSupplier.this.openOutputFile();
                }
                catch (Exception e) {
                    RotatingFileOutputStreamSupplier.this.rotationListener.rotationError(e, (OutputStream)RotatingFileOutputStreamSupplier.this.outRef.get());
                    RotatingFileOutputStreamSupplier.this.rotating.set(false);
                    return;
                }
                OutputStream oldStream = (OutputStream)RotatingFileOutputStreamSupplier.this.outRef.get();
                RotatingFileOutputStreamSupplier.this.rotationListener.outputFileCreated(newStream, oldStream);
                AtomicReference atomicReference = RotatingFileOutputStreamSupplier.this.outRef;
                synchronized (atomicReference) {
                    if (!RotatingFileOutputStreamSupplier.this.closed.get()) {
                        RotatingFileOutputStreamSupplier.this.outRef.set(newStream);
                        RotatingFileOutputStreamSupplier.removeCollectedReferences(RotatingFileOutputStreamSupplier.this.archivedStreams);
                        RotatingFileOutputStreamSupplier.this.archivedStreams.add(new WeakReference<OutputStream>(oldStream));
                    }
                }
                if (RotatingFileOutputStreamSupplier.this.rotationDelaySeconds > 0L) {
                    RotatingFileOutputStreamSupplier.this.earliestRotationTimeRef.set(RotatingFileOutputStreamSupplier.this.currentTimeSupplier.getAsLong() + RotatingFileOutputStreamSupplier.this.rotationDelaySeconds);
                }
                RotatingFileOutputStreamSupplier.this.rotationListener.rotationCompleted(newStream, oldStream);
                RotatingFileOutputStreamSupplier.this.rotating.set(false);
            }
        };
        try {
            this.rotationExecutor.execute(runnable);
        }
        catch (Exception e) {
            this.rotationListener.rotationError(e, this.outRef.get());
            this.rotating.set(false);
        }
    }

    private OutputStream openOutputFile() throws IOException {
        return Files.createOrOpenAsOuputStream((FileSystemAbstraction)this.fileSystem, (File)this.outputFile, (boolean)true);
    }

    private void shiftArchivedOutputFiles() throws IOException {
        for (int i = this.lastArchivedOutputFileNumber(); i > 0; --i) {
            File archive = this.archivedOutputFile(i);
            if (i >= this.maxArchives) {
                this.fileSystem.deleteFile(archive);
                continue;
            }
            this.fileSystem.renameFile(archive, this.archivedOutputFile(i + 1));
        }
    }

    private int lastArchivedOutputFileNumber() {
        int i = 1;
        while (this.fileSystem.fileExists(this.archivedOutputFile(i))) {
            ++i;
        }
        return i - 1;
    }

    private File archivedOutputFile(int archiveNumber) {
        return new File(String.format("%s.%d", this.outputFile.getPath(), archiveNumber));
    }

    private static <T> void removeCollectedReferences(List<WeakReference<T>> referenceList) {
        Iterator<WeakReference<T>> iterator = referenceList.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().get() != null) continue;
            iterator.remove();
        }
    }

    public static class RotationListener {
        public void outputFileCreated(OutputStream newStream, OutputStream oldStream) {
        }

        public void rotationCompleted(OutputStream newStream, OutputStream oldStream) {
        }

        public void rotationError(Exception e, OutputStream out) {
        }
    }
}

