/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files.checkpoint;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.DetachedCheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogVersionVisitor;
import org.neo4j.kernel.impl.transaction.log.files.RangeLogVersionVisitor;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogChannelAllocator;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointInfoFactory;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointLogChannelAllocator;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.DetachedLogTailScanner;
import org.neo4j.kernel.impl.transaction.log.rotation.FileLogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.recovery.LogTailScannerMonitor;
import org.neo4j.logging.InternalLog;
import org.neo4j.monitoring.Panic;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.util.VisibleForTesting;

public class CheckpointLogFile
extends LifecycleAdapter
implements CheckpointFile {
    private final DetachedCheckpointAppender checkpointAppender;
    private final DetachedLogTailScanner logTailScanner;
    private final TransactionLogFilesHelper fileHelper;
    private final TransactionLogChannelAllocator channelAllocator;
    private final LogFiles logFiles;
    private final TransactionLogFilesContext context;
    private final InternalLog log;
    private final long rotationsSize;
    private final LogTailScannerMonitor monitor;
    private final BinarySupportedKernelVersions binarySupportedKernelVersions;
    private LogVersionRepository logVersionRepository;

    public CheckpointLogFile(LogFiles logFiles, TransactionLogFilesContext context) {
        this.context = context;
        this.logFiles = logFiles;
        this.rotationsSize = (Long)context.getConfig().get(GraphDatabaseInternalSettings.checkpoint_logical_log_rotation_threshold);
        this.fileHelper = new TransactionLogFilesHelper(context.getFileSystem(), logFiles.logFilesDirectory(), "checkpoint");
        this.channelAllocator = new CheckpointLogChannelAllocator(context, this.fileHelper);
        this.monitor = (LogTailScannerMonitor)context.getMonitors().newMonitor(LogTailScannerMonitor.class, new String[0]);
        this.logTailScanner = new DetachedLogTailScanner(logFiles, context, this, this.monitor);
        this.log = context.getLogProvider().getLog(this.getClass());
        LogRotationMonitor rotationMonitor = (LogRotationMonitor)context.getMonitors().newMonitor(LogRotationMonitor.class, new String[0]);
        LogRotation checkpointRotation = FileLogRotation.checkpointLogRotation(this, logFiles.getLogFile(), context.getClock(), (Panic)context.getDatabaseHealth(), rotationMonitor);
        this.binarySupportedKernelVersions = context.getBinarySupportedKernelVersions();
        this.checkpointAppender = new DetachedCheckpointAppender(logFiles, this.channelAllocator, context, this, checkpointRotation, this.logTailScanner, this.binarySupportedKernelVersions);
    }

    public void start() throws Exception {
        this.checkpointAppender.start();
        this.logVersionRepository = this.context.getLogVersionRepositoryProvider().logVersionRepository(this.logFiles);
    }

    public void shutdown() throws Exception {
        this.checkpointAppender.shutdown();
    }

    @Override
    public Optional<CheckpointInfo> findLatestCheckpoint() throws IOException {
        return this.findLatestCheckpoint(this.log);
    }

    @Override
    public Optional<CheckpointInfo> findLatestCheckpoint(InternalLog log) throws IOException {
        RangeLogVersionVisitor versionVisitor = new RangeLogVersionVisitor();
        this.fileHelper.accept((LogVersionVisitor)versionVisitor);
        long highestVersion = versionVisitor.getHighestVersion();
        if (highestVersion < 0L) {
            return Optional.empty();
        }
        long lowestVersion = versionVisitor.getLowestVersion();
        long currentVersion = highestVersion;
        VersionAwareLogEntryReader checkpointReader = new VersionAwareLogEntryReader(CommandReaderFactory.NO_COMMANDS, true, this.binarySupportedKernelVersions);
        while (currentVersion >= lowestVersion) {
            CheckpointEntryInfo checkpointEntry = null;
            PhysicalLogVersionedStoreChannel channel = this.channelAllocator.openLogChannel(currentVersion);
            try (ReadAheadLogChannel reader = new ReadAheadLogChannel(channel, LogVersionBridge.NO_MORE_CHANNELS, this.context.getMemoryTracker());
                 LogEntryCursor logEntryCursor = new LogEntryCursor((LogEntryReader)checkpointReader, (ReadableLogPositionAwareChannel)reader);){
                block28: {
                    Optional<CheckpointInfo> optional;
                    log.info("Scanning log file with version %d for checkpoint entries", new Object[]{currentVersion});
                    try {
                        LogPosition lastCheckpointLocation = reader.getCurrentLogPosition();
                        while (logEntryCursor.next()) {
                            LogEntry checkpoint = logEntryCursor.get();
                            checkpointEntry = new CheckpointEntryInfo(checkpoint, lastCheckpointLocation, reader.getCurrentLogPosition());
                            lastCheckpointLocation = reader.getCurrentLogPosition();
                        }
                        if (checkpointEntry != null) {
                            optional = Optional.of(this.createCheckpointInfo(checkpointEntry, reader));
                            return optional;
                        }
                    }
                    catch (Error | ClosedByInterruptException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        this.monitor.corruptedCheckpointFile(currentVersion, t);
                        if (checkpointEntry == null) break block28;
                        optional = Optional.of(this.createCheckpointInfo(checkpointEntry, reader));
                        return optional;
                    }
                }
                --currentVersion;
            }
            finally {
                if (channel == null) continue;
                channel.close();
            }
        }
        return Optional.empty();
    }

    private CheckpointInfo createCheckpointInfo(CheckpointEntryInfo checkpointEntry, ReadAheadLogChannel reader) throws IOException {
        return CheckpointInfoFactory.ofLogEntry(checkpointEntry.checkpoint, checkpointEntry.checkpointEntryPosition, checkpointEntry.channelPositionAfterCheckpoint, reader.getCurrentLogPosition(), this.context, this.logFiles.getLogFile());
    }

    @Override
    public List<CheckpointInfo> reachableCheckpoints() throws IOException {
        RangeLogVersionVisitor versionVisitor = new RangeLogVersionVisitor();
        this.fileHelper.accept((LogVersionVisitor)versionVisitor);
        long highestVersion = versionVisitor.getHighestVersion();
        if (highestVersion < 0L) {
            return Collections.emptyList();
        }
        long currentVersion = versionVisitor.getLowestVersion();
        VersionAwareLogEntryReader checkpointReader = new VersionAwareLogEntryReader(CommandReaderFactory.NO_COMMANDS, true, this.binarySupportedKernelVersions);
        ArrayList<CheckpointInfo> checkpoints = new ArrayList<CheckpointInfo>();
        while (currentVersion <= highestVersion) {
            PhysicalLogVersionedStoreChannel channel = this.channelAllocator.openLogChannel(currentVersion);
            try (ReadAheadLogChannel reader = new ReadAheadLogChannel(channel, LogVersionBridge.NO_MORE_CHANNELS, this.context.getMemoryTracker());
                 LogEntryCursor logEntryCursor = new LogEntryCursor((LogEntryReader)checkpointReader, (ReadableLogPositionAwareChannel)reader);){
                LogPosition lastCheckpointLocation;
                this.log.info("Scanning log file with version %d for checkpoint entries", new Object[]{currentVersion});
                LogPosition lastLocation = lastCheckpointLocation = reader.getCurrentLogPosition();
                while (logEntryCursor.next()) {
                    lastCheckpointLocation = lastLocation;
                    LogEntry checkpoint = logEntryCursor.get();
                    lastLocation = reader.getCurrentLogPosition();
                    checkpoints.add(CheckpointInfoFactory.ofLogEntry(checkpoint, lastCheckpointLocation, lastLocation, lastLocation, this.context, this.logFiles.getLogFile()));
                }
                ++currentVersion;
            }
            finally {
                if (channel == null) continue;
                channel.close();
            }
        }
        return checkpoints;
    }

    @Override
    public List<CheckpointInfo> getReachableDetachedCheckpoints() throws IOException {
        return this.reachableCheckpoints();
    }

    @Override
    public CheckpointAppender getCheckpointAppender() {
        return this.checkpointAppender;
    }

    @Override
    public LogTailMetadata getTailMetadata() {
        return this.logTailScanner.getTailMetadata();
    }

    @Override
    public Path getCurrentFile() throws IOException {
        return this.fileHelper.getLogFileForVersion(this.getCurrentDetachedLogVersion());
    }

    @Override
    public Path getDetachedCheckpointFileForVersion(long logVersion) {
        return this.fileHelper.getLogFileForVersion(logVersion);
    }

    @Override
    public Path[] getDetachedCheckpointFiles() throws IOException {
        return this.fileHelper.getMatchedFiles();
    }

    @Override
    public long getCurrentDetachedLogVersion() throws IOException {
        if (this.logVersionRepository != null) {
            return this.logVersionRepository.getCheckpointLogVersion();
        }
        RangeLogVersionVisitor versionVisitor = new RangeLogVersionVisitor();
        this.fileHelper.accept((LogVersionVisitor)versionVisitor);
        return versionVisitor.getHighestVersion();
    }

    @Override
    public long getDetachedCheckpointLogFileVersion(Path checkpointLogFile) {
        return TransactionLogFilesHelper.getLogVersion((Path)checkpointLogFile);
    }

    @Override
    public boolean rotationNeeded() {
        long position = this.checkpointAppender.getCurrentPosition();
        return position >= this.rotationsSize;
    }

    @Override
    public synchronized Path rotate() throws IOException {
        return this.checkpointAppender.rotate();
    }

    @Override
    public long getLowestLogVersion() {
        return this.visitLogFiles(new RangeLogVersionVisitor()).getLowestVersion();
    }

    @Override
    public PhysicalLogVersionedStoreChannel openForVersion(long checkpointLogVersion) throws IOException {
        return this.channelAllocator.openLogChannel(checkpointLogVersion);
    }

    @Override
    public long getHighestLogVersion() {
        return this.visitLogFiles(new RangeLogVersionVisitor()).getHighestVersion();
    }

    @VisibleForTesting
    public DetachedLogTailScanner getLogTailScanner() {
        return this.logTailScanner;
    }

    private <V extends LogVersionVisitor> V visitLogFiles(V visitor) {
        try {
            for (Path file : this.fileHelper.getMatchedFiles()) {
                visitor.visit(file, TransactionLogFilesHelper.getLogVersion((Path)file));
            }
            return visitor;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private record CheckpointEntryInfo(LogEntry checkpoint, LogPosition checkpointEntryPosition, LogPosition channelPositionAfterCheckpoint) {
    }
}

