/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTypeIndexCursor;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.RelationshipSelection;

public class DefaultNodeBasedRelationshipTypeIndexCursor
extends DefaultRelationshipTypeIndexCursor
implements RelationshipTypeIndexCursor {
    private final DefaultNodeCursor nodeCursor;
    private final DefaultRelationshipTraversalCursor relationshipTraversalCursor;
    private IndexReadState indexReadState = IndexReadState.UNAVAILABLE;
    private RelationshipSelection selection;

    DefaultNodeBasedRelationshipTypeIndexCursor(CursorPool<DefaultRelationshipTypeIndexCursor> pool, DefaultNodeCursor nodeCursor, DefaultRelationshipTraversalCursor relationshipTraversalCursor) {
        super(pool);
        this.nodeCursor = nodeCursor;
        this.relationshipTraversalCursor = relationshipTraversalCursor;
    }

    @Override
    public void initialize(IndexProgressor progressor, int token, IndexOrder order) {
        this.indexReadState = IndexReadState.INDEX_READ;
        this.selection = RelationshipSelection.selection((int)token, (Direction)Direction.OUTGOING);
        super.initialize(progressor, token, IndexOrder.NONE);
    }

    @Override
    public void initialize(IndexProgressor progressor, int token, LongIterator added, LongSet removed, AccessMode accessMode) {
        this.indexReadState = IndexReadState.INDEX_READ;
        this.selection = RelationshipSelection.selection((int)token, (Direction)Direction.OUTGOING);
        super.initialize(progressor, token, added, removed, accessMode);
    }

    public boolean readFromStore() {
        if (this.relationshipTraversalCursor.relationshipReference() == this.entity) {
            return true;
        }
        if (this.entityFromIndex != -1L) {
            this.nodeCursor.single(this.entityFromIndex, this.read);
            if (this.nodeCursor.next()) {
                this.nodeCursor.relationships(this.relationshipTraversalCursor, this.selection);
                boolean next = this.relationshipTraversalCursor.next();
                this.indexReadState = next ? IndexReadState.RELATIONSHIP_READ : IndexReadState.INDEX_READ;
                return next;
            }
        }
        return false;
    }

    public long sourceNodeReference() {
        this.checkReadFromStore();
        return this.relationshipTraversalCursor.sourceNodeReference();
    }

    public long targetNodeReference() {
        this.checkReadFromStore();
        return this.relationshipTraversalCursor.targetNodeReference();
    }

    public void properties(PropertyCursor cursor, PropertySelection propSelection) {
        this.checkReadFromStore();
        this.relationshipTraversalCursor.properties(cursor, propSelection);
    }

    public Reference propertiesReference() {
        this.checkReadFromStore();
        return this.relationshipTraversalCursor.propertiesReference();
    }

    @Override
    public void closeInternal() {
        if (!this.isClosed()) {
            this.indexReadState = IndexReadState.UNAVAILABLE;
            this.nodeCursor.close();
            this.relationshipTraversalCursor.close();
        }
        super.closeInternal();
    }

    @Override
    public void release() {
        this.nodeCursor.close();
        this.nodeCursor.release();
        this.relationshipTraversalCursor.close();
        this.relationshipTraversalCursor.release();
    }

    public String toString() {
        if (this.isClosed()) {
            return "RelationshipTypeIndexCursor[closed state, node based]";
        }
        return "RelationshipTypeIndexCursor[relationship=" + this.relationshipReference() + ", node based]";
    }

    @Override
    protected long nextEntity() {
        return this.relationshipTraversalCursor.relationshipReference();
    }

    @Override
    protected boolean innerNext() {
        while (true) {
            switch (this.indexReadState) {
                case INDEX_READ: {
                    this.indexReadState = this.indexNext() ? IndexReadState.NODE_READ : IndexReadState.UNAVAILABLE;
                    break;
                }
                case NODE_READ: {
                    this.nodeCursor.single(this.entityFromIndex, this.read);
                    if (this.nodeCursor.next()) {
                        this.nodeCursor.relationships(this.relationshipTraversalCursor, this.selection);
                        this.indexReadState = IndexReadState.RELATIONSHIP_READ;
                        break;
                    }
                    this.indexReadState = IndexReadState.INDEX_READ;
                    break;
                }
                case RELATIONSHIP_READ: {
                    while (this.relationshipTraversalCursor.next()) {
                        if (this.relationshipTraversalCursor.currentAddedInTx != -1L) continue;
                        return true;
                    }
                    this.indexReadState = IndexReadState.INDEX_READ;
                    break;
                }
                case UNAVAILABLE: {
                    return false;
                }
            }
        }
    }

    @Override
    protected LongIterator createAddedInTxState(TransactionState txState, int token, IndexOrder order) {
        final LongIterator relationships = this.read.txState().relationshipsWithTypeChanged(token).getAdded().freeze().longIterator();
        return new LongIterator(){

            public boolean hasNext() {
                return relationships.hasNext();
            }

            public long next() {
                long relationship = relationships.next();
                DefaultNodeBasedRelationshipTypeIndexCursor.this.relationshipTraversalCursor.init(relationship, DefaultNodeBasedRelationshipTypeIndexCursor.this.read);
                return DefaultNodeBasedRelationshipTypeIndexCursor.this.relationshipTraversalCursor.next() ? relationship : -1L;
            }
        };
    }

    @Override
    protected LongSet createDeletedInTxState(TransactionState txState, int token) {
        return this.read.txState().addedAndRemovedNodes().getRemoved().freeze();
    }

    @Override
    protected boolean allowedToSeeEntity(AccessMode accessMode, long entityReference) {
        return true;
    }

    private void checkReadFromStore() {
        if (this.relationshipTraversalCursor.relationshipReference() != this.entity) {
            throw new IllegalStateException("Relationship hasn't been read from store");
        }
    }

    private static enum IndexReadState {
        INDEX_READ,
        NODE_READ,
        RELATIONSHIP_READ,
        UNAVAILABLE;

    }
}

