/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.LongPredicate;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.common.EntityType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryConflictHandler;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.DefaultTokenIndexReader;
import org.neo4j.kernel.impl.index.schema.EntityTokenRange;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracker;
import org.neo4j.kernel.impl.index.schema.NativeAllEntriesTokenScanReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderWriter;
import org.neo4j.kernel.impl.index.schema.TokenIndex;
import org.neo4j.kernel.impl.index.schema.TokenIndexUpdater;
import org.neo4j.kernel.impl.index.schema.TokenScanKey;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;
import org.neo4j.scheduler.JobScheduler;

public class TokenIndexAccessor
extends TokenIndex
implements IndexAccessor {
    private final EntityType entityType;
    private final NativeIndexHeaderWriter headerWriter = new NativeIndexHeaderWriter(0);

    public TokenIndexAccessor(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexDescriptor descriptor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, ImmutableSet<OpenOption> openOptions, boolean readOnly) {
        super(databaseIndexContext, indexFiles, descriptor, openOptions, readOnly);
        this.entityType = descriptor.schema().entityType();
        this.instantiateTree(recoveryCleanupWorkCollector);
        this.instantiateUpdater();
    }

    public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext, boolean parallel) {
        this.assertTreeOpen();
        this.assertWritable();
        try {
            if (parallel) {
                TokenIndexUpdater parallelUpdater = new TokenIndexUpdater(1000);
                return parallelUpdater.initialize((Writer<TokenScanKey, TokenScanValue>)this.index.writer(cursorContext));
            }
            return this.singleUpdater.initialize((Writer<TokenScanKey, TokenScanValue>)this.index.writer(1, cursorContext));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void insertFrom(IndexAccessor other, LongToLongFunction entityIdConverter, boolean valueUniqueness, IndexEntryConflictHandler conflictHandler, LongPredicate entityFilter, int threads, JobScheduler jobScheduler, ProgressListener progress) throws IndexEntryConflictException {
        throw new UnsupportedOperationException();
    }

    public void validate(IndexAccessor other, boolean valueUniqueness, IndexEntryConflictHandler conflictHandler, LongPredicate entityFilter, int threads, JobScheduler jobScheduler) {
        throw new UnsupportedOperationException();
    }

    public void force(FileFlushEvent flushEvent, CursorContext cursorContext) {
        this.index.checkpoint((Consumer)this.headerWriter, flushEvent, cursorContext);
    }

    public void refresh() {
    }

    public void close() {
        this.closeResources();
    }

    public ValueIndexReader newValueReader(IndexUsageTracker usageTracker) {
        throw new UnsupportedOperationException("Not applicable for token indexes ");
    }

    public TokenIndexReader newTokenReader(IndexUsageTracker usageTracker) {
        this.assertTreeOpen();
        return new DefaultTokenIndexReader((GBPTree<TokenScanKey, TokenScanValue>)this.index, usageTracker);
    }

    public BoundedIterable<EntityTokenRange> newAllEntriesTokenReader(long fromEntityId, long toEntityId, CursorContext cursorContext) {
        IntFunction<Seeker<TokenScanKey, TokenScanValue>> seekProvider = tokenId -> {
            try {
                return this.index.seek((Object)new TokenScanKey().set(tokenId, fromEntityId / 64L), (Object)new TokenScanKey().set(tokenId, (toEntityId - 1L) / 64L + 1L), cursorContext);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        int highestTokenId = -1;
        try (Seeker cursor = this.index.seek((Object)new TokenScanKey().set(Integer.MAX_VALUE, Long.MAX_VALUE), (Object)new TokenScanKey().set(0, -1L), cursorContext);){
            if (cursor.next()) {
                highestTokenId = ((TokenScanKey)cursor.key()).tokenId;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new NativeAllEntriesTokenScanReader(seekProvider, highestTokenId, this.entityType);
    }

    public BoundedIterable<Long> newAllEntriesValueReader(long fromIdInclusive, long toIdExclusive, CursorContext cursorContext) {
        throw new UnsupportedOperationException("Not applicable for token indexes");
    }

    public ResourceIterator<Path> snapshotFiles() {
        return Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)this.indexFiles.getStoreFile()));
    }

    public long estimateNumberOfEntries(CursorContext cursorContext) {
        throw new UnsupportedOperationException("Not applicable for token indexes");
    }

    public void drop() {
        this.index.setDeleteOnClose(true);
        this.closeResources();
        this.indexFiles.clear();
    }
}

