/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexQuery;

class QueryValidator {
    QueryValidator() {
    }

    static void validateOrder(IndexCapability capability, IndexOrder indexOrder, PropertyIndexQuery ... predicates) {
        if (indexOrder == IndexOrder.NONE) {
            return;
        }
        if (!capability.supportsOrdering()) {
            QueryValidator.invalidOrder(indexOrder, predicates);
        }
    }

    static void validateCompositeQuery(PropertyIndexQuery ... predicates) {
        if (predicates.length == 1 && predicates[0].type() == IndexQuery.IndexQueryType.FULLTEXT_SEARCH) {
            QueryValidator.invalidQuerySingular(IndexQuery.IndexQueryType.FULLTEXT_SEARCH, predicates);
        }
        block7: for (int i = 1; i < predicates.length; ++i) {
            IndexQuery.IndexQueryType type = predicates[i].type();
            IndexQuery.IndexQueryType prevType = predicates[i - 1].type();
            switch (type) {
                case EXISTS: {
                    switch (prevType) {
                        case EXISTS: 
                        case EXACT: 
                        case RANGE: 
                        case BOUNDING_BOX: 
                        case STRING_PREFIX: {
                            continue block7;
                        }
                    }
                    QueryValidator.invalidQueryInComposite(prevType, predicates);
                    continue block7;
                }
                case EXACT: 
                case RANGE: 
                case BOUNDING_BOX: 
                case STRING_PREFIX: {
                    if (prevType == IndexQuery.IndexQueryType.EXACT) continue block7;
                    QueryValidator.invalidQueryPrecisionInComposite(predicates);
                    continue block7;
                }
                default: {
                    QueryValidator.invalidQueryInComposite(type, predicates);
                }
            }
        }
    }

    private static void invalidOrder(IndexOrder indexOrder, PropertyIndexQuery ... predicates) {
        throw new UnsupportedOperationException(String.format("Tried to query index with unsupported order %s. For query %s supports ascending: false, supports descending: false.", indexOrder, Arrays.toString(predicates)));
    }

    private static void invalidQuerySingular(IndexQuery.IndexQueryType type, PropertyIndexQuery ... predicates) {
        throw new IllegalArgumentException(String.format("Tried to query index with illegal composite query. %s queries are not allowed on this index. Query was: %s ", type, Arrays.toString(predicates)));
    }

    private static void invalidQueryInComposite(IndexQuery.IndexQueryType type, PropertyIndexQuery ... predicates) {
        throw new IllegalArgumentException(String.format("Tried to query index with illegal composite query. %s queries are not allowed in composite query. Query was: %s ", type, Arrays.toString(predicates)));
    }

    private static void invalidQueryPrecisionInComposite(PropertyIndexQuery ... predicates) {
        throw new IllegalArgumentException(String.format("Tried to query index with illegal composite query. Composite query must have decreasing precision. Query was: %s ", Arrays.toString(predicates)));
    }
}

