/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.time.Clock;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.impl.api.index.ContractCheckingIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedPopulatingIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;
import org.neo4j.kernel.impl.api.index.PopulatingIndexProxy;
import org.neo4j.kernel.impl.api.index.RecoveringIndexProxy;
import org.neo4j.kernel.impl.api.index.TentativeConstraintIndexProxy;
import org.neo4j.kernel.impl.api.index.TokenIndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.ValueIndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.index.schema.DefaultIndexUsageTracking;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryTracker;

class IndexProxyCreator {
    private final IndexSamplingConfig samplingConfig;
    private final IndexStatisticsStore indexStatisticsStore;
    private final IndexProviderMap providerMap;
    private final TokenNameLookup tokenNameLookup;
    private final InternalLogProvider logProvider;
    private final ImmutableSet<OpenOption> openOptions;
    private final Clock clock;
    private final boolean enableIndexUsageStatistics;

    IndexProxyCreator(IndexSamplingConfig samplingConfig, IndexStatisticsStore indexStatisticsStore, IndexProviderMap providerMap, TokenNameLookup tokenNameLookup, InternalLogProvider logProvider, ImmutableSet<OpenOption> openOptions, Clock clock, boolean enableIndexUsageStatistics) {
        this.samplingConfig = samplingConfig;
        this.indexStatisticsStore = indexStatisticsStore;
        this.providerMap = providerMap;
        this.tokenNameLookup = tokenNameLookup;
        this.logProvider = logProvider;
        this.openOptions = openOptions;
        this.clock = clock;
        this.enableIndexUsageStatistics = enableIndexUsageStatistics;
    }

    IndexProxy createPopulatingIndexProxy(IndexDescriptor index, boolean flipToTentative, IndexMonitor monitor, IndexPopulationJob populationJob) {
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        IndexPopulator populator = this.populatorFromProvider(index, this.samplingConfig, populationJob.bufferFactory(), populationJob.getMemoryTracker());
        IndexProxyStrategy indexProxyStrategy = this.createIndexProxyStrategy(index);
        FailedPopulatingIndexProxyFactory failureDelegateFactory = new FailedPopulatingIndexProxyFactory(indexProxyStrategy, (MinimalIndexAccessor)populator, this.logProvider);
        MultipleIndexPopulator.IndexPopulation indexPopulation = populationJob.addPopulator(populator, indexProxyStrategy, flipper, failureDelegateFactory);
        PopulatingIndexProxy populatingIndex = new PopulatingIndexProxy(index, populationJob, indexPopulation);
        flipper.flipTo(populatingIndex);
        flipper.setFlipTarget(() -> {
            monitor.populationCompleteOn(index);
            IndexUsageTracking usageTracking = this.createIndexUsageTracking();
            IndexAccessor accessor = this.onlineAccessorFromProvider(index, this.samplingConfig);
            OnlineIndexProxy onlineProxy = new OnlineIndexProxy(indexProxyStrategy, accessor, true, usageTracking);
            if (flipToTentative) {
                return new TentativeConstraintIndexProxy(flipper, onlineProxy);
            }
            return onlineProxy;
        });
        return new ContractCheckingIndexProxy(flipper);
    }

    IndexProxy createRecoveringIndexProxy(IndexDescriptor descriptor) {
        RecoveringIndexProxy proxy = new RecoveringIndexProxy(descriptor);
        return new ContractCheckingIndexProxy(proxy);
    }

    IndexProxy createOnlineIndexProxy(IndexDescriptor descriptor) {
        try {
            IndexUsageTracking usageTracking = this.createIndexUsageTracking();
            IndexAccessor onlineAccessor = this.onlineAccessorFromProvider(descriptor, this.samplingConfig);
            IndexProxyStrategy indexProxyStrategy = this.createIndexProxyStrategy(descriptor);
            OnlineIndexProxy proxy = new OnlineIndexProxy(indexProxyStrategy, onlineAccessor, false, usageTracking);
            return new ContractCheckingIndexProxy(proxy);
        }
        catch (IOException | RuntimeException e) {
            this.logProvider.getLog(this.getClass()).error("Failed to open index: " + descriptor.getId() + " (" + descriptor.userDescription(this.tokenNameLookup) + "), requesting re-population.", (Throwable)e);
            return this.createRecoveringIndexProxy(descriptor);
        }
    }

    private IndexProxyStrategy createIndexProxyStrategy(IndexDescriptor descriptor) {
        if (descriptor.getIndexType() == IndexType.LOOKUP) {
            return new TokenIndexProxyStrategy(descriptor, this.tokenNameLookup);
        }
        return new ValueIndexProxyStrategy(descriptor, this.indexStatisticsStore, this.tokenNameLookup);
    }

    IndexProxy createFailedIndexProxy(IndexDescriptor descriptor, IndexPopulationFailure populationFailure) {
        MinimalIndexAccessor minimalIndexAccessor = this.minimalIndexAccessorFromProvider(descriptor);
        IndexProxyStrategy indexProxyStrategy = this.createIndexProxyStrategy(descriptor);
        FailedIndexProxy proxy = new FailedIndexProxy(indexProxyStrategy, minimalIndexAccessor, populationFailure, this.logProvider);
        return new ContractCheckingIndexProxy(proxy);
    }

    private IndexPopulator populatorFromProvider(IndexDescriptor index, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker) {
        IndexProvider provider = this.providerMap.lookup(index.getIndexProvider());
        return provider.getPopulator(index, samplingConfig, bufferFactory, memoryTracker, this.tokenNameLookup, this.openOptions);
    }

    private MinimalIndexAccessor minimalIndexAccessorFromProvider(IndexDescriptor index) {
        IndexProvider provider = this.providerMap.lookup(index.getIndexProvider());
        return provider.getMinimalIndexAccessor(index);
    }

    private IndexAccessor onlineAccessorFromProvider(IndexDescriptor index, IndexSamplingConfig samplingConfig) throws IOException {
        IndexProvider provider = this.providerMap.lookup(index.getIndexProvider());
        return provider.getOnlineAccessor(index, samplingConfig, this.tokenNameLookup, this.openOptions);
    }

    private IndexUsageTracking createIndexUsageTracking() {
        return this.enableIndexUsageStatistics ? new DefaultIndexUsageTracking(this.clock) : IndexUsageTracking.NO_USAGE_TRACKING;
    }
}

