/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.DelegatingIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.updater.DelegatingIndexUpdater;
import org.neo4j.util.VisibleForTesting;

class ContractCheckingIndexProxy
extends DelegatingIndexProxy {
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private final AtomicInteger openCalls = new AtomicInteger(0);

    ContractCheckingIndexProxy(IndexProxy delegate) {
        super(delegate);
    }

    @Override
    public void start() {
        if (this.state.compareAndSet(State.INIT, State.STARTING)) {
            try {
                super.start();
            }
            finally {
                this.state.set(State.STARTED);
            }
        } else {
            throw new IllegalStateException("An IndexProxy can only be started once");
        }
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext, boolean parallel) {
        if (IndexUpdateMode.ONLINE == mode) {
            if (this.tryOpenCall()) {
                try {
                    return new DelegatingIndexUpdater(super.newUpdater(mode, cursorContext, parallel)){

                        @Override
                        public void close() throws IndexEntryConflictException {
                            try {
                                this.delegate.close();
                            }
                            finally {
                                ContractCheckingIndexProxy.this.closeCall();
                            }
                        }
                    };
                }
                catch (Throwable e) {
                    this.closeCall();
                    throw e;
                }
            }
            throw new IllegalStateException("Cannot create new updater when index state is " + (Object)((Object)this.state.get()));
        }
        return super.newUpdater(mode, cursorContext, parallel);
    }

    @Override
    public void force(FileFlushEvent flushEvent, CursorContext cursorContext) throws IOException {
        if (this.tryOpenCall()) {
            try {
                super.force(flushEvent, cursorContext);
            }
            finally {
                this.closeCall();
            }
        }
    }

    @Override
    public void drop() {
        if (this.state.compareAndSet(State.INIT, State.CLOSED)) {
            super.drop();
            return;
        }
        if (State.STARTING == this.state.get()) {
            throw new IllegalStateException("Concurrent drop while creating index");
        }
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            this.waitOpenCallsToClose();
            super.drop();
            return;
        }
        throw new IllegalStateException("IndexProxy already closed");
    }

    @Override
    public void close(CursorContext cursorContext) throws IOException {
        if (this.state.compareAndSet(State.INIT, State.CLOSED)) {
            super.close(cursorContext);
            return;
        }
        if (this.state.compareAndSet(State.STARTING, State.CLOSED)) {
            throw new IllegalStateException("Concurrent close while creating index");
        }
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            this.waitOpenCallsToClose();
            super.close(cursorContext);
            return;
        }
        throw new IllegalStateException("IndexProxy already closed");
    }

    private void waitOpenCallsToClose() {
        while (this.openCalls.intValue() > 0) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
    }

    @VisibleForTesting
    int getOpenCalls() {
        return this.openCalls.intValue();
    }

    private boolean tryOpenCall() {
        if (State.STARTED == this.state.get()) {
            this.openCalls.incrementAndGet();
            if (State.STARTED == this.state.get()) {
                return true;
            }
            this.openCalls.decrementAndGet();
        }
        return false;
    }

    private void closeCall() {
        this.openCalls.decrementAndGet();
    }

    private static enum State {
        INIT,
        STARTING,
        STARTED,
        CLOSED;

    }
}

