/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.StorageCommand;

public class LogEntryWriter<T extends WritableChecksumChannel> {
    protected final T channel;

    public LogEntryWriter(T channel) {
        this.channel = channel;
    }

    public void writeLogEntryHeader(byte version, byte type, WritableChannel channel) throws IOException {
        channel.put(version).put(type);
    }

    public void writeStartEntry(byte version, long timeWritten, long latestCommittedTxWhenStarted, int previousChecksum, byte[] additionalHeaderData) throws IOException {
        this.channel.beginChecksum();
        this.writeLogEntryHeader(version, (byte)1, (WritableChannel)this.channel);
        this.channel.putLong(timeWritten).putLong(latestCommittedTxWhenStarted).putInt(previousChecksum).putInt(additionalHeaderData.length).put(additionalHeaderData, additionalHeaderData.length);
    }

    public void writeChunkStartEntry(byte version, long timeWritten, long chunkId, LogPosition previousChunkStart) throws IOException {
        this.channel.beginChecksum();
        this.writeLogEntryHeader(version, (byte)10, (WritableChannel)this.channel);
        this.channel.putLong(timeWritten).putLong(chunkId).putLong(previousChunkStart.getLogVersion()).putLong(previousChunkStart.getByteOffset());
    }

    public int writeChunkEndEntry(byte version, long transactionId, long chunkId) throws IOException {
        this.writeLogEntryHeader(version, (byte)11, (WritableChannel)this.channel);
        this.channel.putLong(transactionId);
        this.channel.putLong(chunkId);
        return this.channel.putChecksum();
    }

    public int writeRollbackEntry(byte version, long transactionId, long timeWritten) throws IOException {
        this.channel.beginChecksum();
        this.writeLogEntryHeader(version, (byte)13, (WritableChannel)this.channel);
        this.channel.putLong(transactionId).putLong(timeWritten);
        return this.channel.putChecksum();
    }

    public int writeCommitEntry(byte version, long transactionId, long timeWritten) throws IOException {
        this.writeLogEntryHeader(version, (byte)5, (WritableChannel)this.channel);
        this.channel.putLong(transactionId).putLong(timeWritten);
        return this.channel.putChecksum();
    }

    public void serialize(CommandBatch batch) throws IOException {
        this.serialize((Iterable<StorageCommand>)batch, batch.kernelVersion());
    }

    public void serialize(CommittedCommandBatch commandBatch) throws IOException {
        commandBatch.serialize(this);
    }

    public void serialize(Iterable<StorageCommand> commands, KernelVersion kernelVersion) throws IOException {
        byte version = kernelVersion.version();
        for (StorageCommand storageCommand : commands) {
            this.writeLogEntryHeader(version, (byte)3, (WritableChannel)this.channel);
            storageCommand.serialize(this.channel);
        }
    }

    public void serialize(StorageCommand command, KernelVersion kernelVersion) throws IOException {
        this.writeLogEntryHeader(kernelVersion.version(), (byte)3, (WritableChannel)this.channel);
        command.serialize(this.channel);
    }

    public T getChannel() {
        return this.channel;
    }
}

