/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.FlushableChecksumChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableLogChannel;

public class PositionAwarePhysicalFlushableChecksumChannel
implements FlushablePositionAwareChecksumChannel {
    private LogVersionedStoreChannel logVersionedStoreChannel;
    private final PhysicalFlushableLogChannel channel;

    public PositionAwarePhysicalFlushableChecksumChannel(LogVersionedStoreChannel logVersionedStoreChannel, ScopedBuffer buffer) {
        this.logVersionedStoreChannel = logVersionedStoreChannel;
        this.channel = new PhysicalFlushableLogChannel((StoreChannel)logVersionedStoreChannel, buffer);
    }

    public LogPositionMarker getCurrentPosition(LogPositionMarker positionMarker) throws IOException {
        positionMarker.mark(this.logVersionedStoreChannel.getVersion(), this.channel.position());
        return positionMarker;
    }

    public LogPosition getCurrentPosition() throws IOException {
        return new LogPosition(this.logVersionedStoreChannel.getVersion(), this.channel.position());
    }

    public Flushable prepareForFlush() throws IOException {
        return this.channel.prepareForFlush();
    }

    public int putChecksum() throws IOException {
        return this.channel.putChecksum();
    }

    public void beginChecksum() {
        this.channel.beginChecksum();
    }

    public FlushableChecksumChannel put(byte value) throws IOException {
        return this.channel.put(value);
    }

    public FlushableChecksumChannel putShort(short value) throws IOException {
        return this.channel.putShort(value);
    }

    public FlushableChecksumChannel putInt(int value) throws IOException {
        return this.channel.putInt(value);
    }

    public FlushableChecksumChannel putLong(long value) throws IOException {
        return this.channel.putLong(value);
    }

    public FlushableChecksumChannel putFloat(float value) throws IOException {
        return this.channel.putFloat(value);
    }

    public FlushableChecksumChannel putDouble(double value) throws IOException {
        return this.channel.putDouble(value);
    }

    public FlushableChecksumChannel put(byte[] value, int offset, int length) throws IOException {
        return this.channel.put(value, offset, length);
    }

    public FlushableChecksumChannel putAll(ByteBuffer src) throws IOException {
        return this.channel.putAll(src);
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public void write(ByteBuffer buffer) throws IOException {
        this.logVersionedStoreChannel.writeAll(buffer);
    }

    public void setChannel(LogVersionedStoreChannel channel) {
        this.logVersionedStoreChannel = channel;
        this.channel.setChannel((StoreChannel)channel);
    }
}

