/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NullValue;
import org.neo4j.kernel.impl.index.schema.PointIndexProvider;
import org.neo4j.kernel.impl.index.schema.PointIndexReader;
import org.neo4j.kernel.impl.index.schema.PointKey;
import org.neo4j.kernel.impl.index.schema.SpatialConfigVisitor;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.values.storable.Value;

class PointIndexAccessor
extends NativeIndexAccessor<PointKey> {
    private final IndexSpecificSpaceFillingCurveSettings spaceFillingCurveSettings;
    private final SpaceFillingCurveConfiguration configuration;

    PointIndexAccessor(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexLayout<PointKey> layout, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexDescriptor descriptor, IndexSpecificSpaceFillingCurveSettings spaceFillingCurveSettings, SpaceFillingCurveConfiguration configuration, ImmutableSet<OpenOption> openOptions, boolean readOnly) {
        super(databaseIndexContext, indexFiles, layout, descriptor, openOptions, readOnly);
        this.spaceFillingCurveSettings = spaceFillingCurveSettings;
        this.configuration = configuration;
        this.instantiateTree(recoveryCleanupWorkCollector);
    }

    @Override
    public ValueIndexReader newValueReader(IndexUsageTracking usageTracker) {
        this.assertOpen();
        return new PointIndexReader((GBPTree<PointKey, NullValue>)this.tree, this.layout, this.descriptor, this.spaceFillingCurveSettings, this.configuration, usageTracker);
    }

    public void validateBeforeCommit(long entityId, Value[] tuple) {
    }

    public Map<String, Value> indexConfig() {
        HashMap<String, Value> map = new HashMap<String, Value>();
        this.spaceFillingCurveSettings.visitIndexSpecificSettings(new SpatialConfigVisitor(map));
        return map;
    }

    @Override
    protected IndexUpdateIgnoreStrategy indexUpdateIgnoreStrategy() {
        return PointIndexProvider.UPDATE_IGNORE_STRATEGY;
    }
}

