/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import java.net.URL;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.security.URIAccessRules;
import org.neo4j.kernel.impl.security.WebURLAccessRule;

public class ProcedureUrlAccessChecker
implements URLAccessChecker {
    private final WebURLAccessRule webURLAccessRule;
    private final SecurityAuthorizationHandler securityAuthorizationHandler;
    private final SecurityContext securityContext;

    public ProcedureUrlAccessChecker(WebURLAccessRule webURLAccessRule, SecurityAuthorizationHandler securityAuthorizationHandler, SecurityContext securityContext) {
        this.webURLAccessRule = webURLAccessRule;
        this.securityAuthorizationHandler = securityAuthorizationHandler;
        this.securityContext = securityContext;
    }

    public URL checkURL(URL url) throws URLAccessValidationError {
        try {
            if (URIAccessRules.WEB_SCHEMES.contains(url.getProtocol())) {
                return this.webURLAccessRule.checkNotBlockedAndPinToIP(url, this.securityAuthorizationHandler, this.securityContext);
            }
            this.securityAuthorizationHandler.assertLoadAllowed(this.securityContext, url.toURI(), null);
            return url;
        }
        catch (Exception e) {
            if (e instanceof URLAccessValidationError) {
                throw (URLAccessValidationError)e;
            }
            throw new URLAccessValidationError("Unable to verify access to " + url.getHost() + ". Cause: " + e.getMessage());
        }
    }
}

