/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.dbms.database.DatabaseStartAbortedException;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatchRepresentation;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.recovery.CorruptedLogsTruncator;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryApplier;
import org.neo4j.kernel.recovery.RecoveryContextTracker;
import org.neo4j.kernel.recovery.RecoveryMode;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryPredicate;
import org.neo4j.kernel.recovery.RecoveryPredicateException;
import org.neo4j.kernel.recovery.RecoveryService;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.kernel.recovery.RecoveryStartupChecker;
import org.neo4j.kernel.recovery.RollbackTransactionInfo;
import org.neo4j.kernel.recovery.TransactionIdTracker;
import org.neo4j.kernel.recovery.TransactionStatus;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.AppendIndexProvider;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.time.Stopwatch;

public class TransactionLogsRecovery
extends LifecycleAdapter {
    private static final String REVERSE_RECOVERY_TAG = "restoreDatabase";
    private static final String RECOVERY_TAG = "recoverDatabase";
    private static final String RECOVERY_COMPLETED_TAG = "databaseRecoveryCompleted";
    private final LogFiles logFiles;
    private final KernelVersionProvider versionProvider;
    private final RecoveryService recoveryService;
    private final RecoveryMonitor monitor;
    private final CorruptedLogsTruncator logsTruncator;
    private final Lifecycle schemaLife;
    private final ProgressMonitorFactory progressMonitorFactory;
    private final boolean failOnCorruptedLogFiles;
    private final RecoveryStartupChecker recoveryStartupChecker;
    private final boolean rollbackIncompleteTransactions;
    private final CursorContextFactory contextFactory;
    private final RecoveryPredicate recoveryPredicate;
    private final Clock clock;
    private final BinarySupportedKernelVersions binarySupportedKernelVersions;
    private final RecoveryMode mode;
    private ProgressListener progressListener;

    public TransactionLogsRecovery(LogFiles logFiles, KernelVersionProvider versionProvider, RecoveryService recoveryService, CorruptedLogsTruncator logsTruncator, Lifecycle schemaLife, RecoveryMonitor monitor, ProgressMonitorFactory progressMonitorFactory, boolean failOnCorruptedLogFiles, RecoveryStartupChecker recoveryStartupChecker, RecoveryPredicate recoveryPredicate, boolean rollbackIncompleteTransactions, CursorContextFactory contextFactory, Clock clock, BinarySupportedKernelVersions binarySupportedKernelVersions, RecoveryMode mode) {
        this.logFiles = logFiles;
        this.versionProvider = versionProvider;
        this.recoveryService = recoveryService;
        this.monitor = monitor;
        this.logsTruncator = logsTruncator;
        this.schemaLife = schemaLife;
        this.progressMonitorFactory = progressMonitorFactory;
        this.failOnCorruptedLogFiles = failOnCorruptedLogFiles;
        this.recoveryStartupChecker = recoveryStartupChecker;
        this.rollbackIncompleteTransactions = rollbackIncompleteTransactions;
        this.contextFactory = contextFactory;
        this.recoveryPredicate = recoveryPredicate;
        this.clock = clock;
        this.binarySupportedKernelVersions = binarySupportedKernelVersions;
        this.mode = mode;
        this.progressListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws Exception {
        RecoveryRollbackAppendIndexProvider appendIndexProvider;
        RecoveryContextTracker recoveryContextTracker;
        Stopwatch recoveryStartTime;
        RecoveryStartInformation recoveryStartInformation;
        block47: {
            recoveryStartInformation = this.recoveryService.getRecoveryStartInformation();
            if (!recoveryStartInformation.isRecoveryRequired()) {
                this.schemaLife.init();
                return;
            }
            recoveryStartTime = Stopwatch.start();
            TransactionIdTracker transactionIdTracker = new TransactionIdTracker();
            LogPosition recoveryStartPosition = recoveryStartInformation.transactionLogPosition();
            this.monitor.recoveryRequired(recoveryStartInformation);
            recoveryContextTracker = new RecoveryContextTracker(recoveryStartPosition, recoveryStartInformation.checkpointInfo());
            appendIndexProvider = null;
            boolean incompleteBatchEncountered = false;
            try {
                if (recoveryStartInformation.missingLogs()) break block47;
                try {
                    this.reverseRecovery(recoveryStartInformation, transactionIdTracker);
                    this.schemaLife.init();
                    boolean fullRecovery = true;
                    try (CommandBatchCursor transactionsToRecover = this.recoveryService.getCommandBatches(recoveryStartPosition);
                         RecoveryApplier recoveryVisitor = this.recoveryService.getRecoveryApplier(TransactionApplicationMode.RECOVERY, this.contextFactory, RECOVERY_TAG);){
                        while (fullRecovery && transactionsToRecover.next()) {
                            CommittedCommandBatchRepresentation nextCommandBatch = (CommittedCommandBatchRepresentation)transactionsToRecover.get();
                            if (!this.recoveryPredicate.test(nextCommandBatch)) {
                                this.monitor.partialRecovery(this.recoveryPredicate, recoveryContextTracker.getLastHighestTransactionBatchInfo());
                                fullRecovery = false;
                                if (recoveryContextTracker.hasRecoveredBatches()) continue;
                                long beforeCheckpointAppendIndex = recoveryStartInformation.firstAppendIndexAfterLastCheckPoint() - 1L;
                                if (beforeCheckpointAppendIndex < 1L) {
                                    throw new RecoveryPredicateException(String.format("Partial recovery criteria can't be satisfied. No transaction after checkpoint matching to provided criteria found and transaction before checkpoint is not valid. Append index before checkpoint: %d, criteria %s.", beforeCheckpointAppendIndex, this.recoveryPredicate.describe()));
                                }
                                try {
                                    CommandBatchCursor beforeCheckpointCursor = this.recoveryService.getCommandBatches(beforeCheckpointAppendIndex);
                                    try {
                                        if (beforeCheckpointCursor.next()) {
                                            CommittedCommandBatchRepresentation candidate = (CommittedCommandBatchRepresentation)beforeCheckpointCursor.get();
                                            if (!this.recoveryPredicate.test(candidate)) {
                                                throw new RecoveryPredicateException(String.format("Partial recovery criteria can't be satisfied. Transaction after and before checkpoint does not satisfy provided recovery criteria. Observed transaction id: %d, recovery criteria: %s.", candidate.txId(), this.recoveryPredicate.describe()));
                                            }
                                            recoveryContextTracker.commitedBatch(candidate, beforeCheckpointCursor.position());
                                            continue;
                                        }
                                        throw new RecoveryPredicateException(String.format("Partial recovery criteria can't be satisfied. No transaction after checkpoint matching to provided criteria found and transaction before checkpoint not found. Recovery criteria: %s.", this.recoveryPredicate.describe()));
                                    }
                                    finally {
                                        if (beforeCheckpointCursor == null) continue;
                                        beforeCheckpointCursor.close();
                                        continue;
                                    }
                                }
                                catch (RecoveryPredicateException re) {
                                    throw re;
                                }
                                catch (Exception e) {
                                    throw new RecoveryPredicateException(String.format("Partial recovery criteria can't be satisfied. No transaction after checkpoint matching to provided criteria found and fail to read transaction before checkpoint. Recovery criteria: %s.", this.recoveryPredicate.describe()), e);
                                }
                            }
                            this.recoveryStartupChecker.checkIfCanceled();
                            switch (transactionIdTracker.transactionStatus(nextCommandBatch.txId())) {
                                case RECOVERABLE: {
                                    recoveryVisitor.visit(nextCommandBatch);
                                    this.monitor.batchRecovered(nextCommandBatch);
                                    break;
                                }
                                case ROLLED_BACK: {
                                    this.monitor.batchApplySkipped(nextCommandBatch);
                                    break;
                                }
                                case INCOMPLETE: {
                                    this.monitor.batchApplySkipped(nextCommandBatch);
                                    if (this.rollbackIncompleteTransactions) break;
                                    fullRecovery = false;
                                    incompleteBatchEncountered = true;
                                    break;
                                }
                            }
                            if (!incompleteBatchEncountered) {
                                recoveryContextTracker.commitedBatch(nextCommandBatch, transactionsToRecover.position());
                            }
                            this.reportProgress();
                        }
                        recoveryContextTracker.completeRecovery(fullRecovery ? transactionsToRecover.position() : recoveryContextTracker.getLastTransactionPosition());
                    }
                }
                catch (Error | ClosedByInterruptException | DatabaseStartAbortedException | RecoveryPredicateException e) {
                    throw e;
                }
                catch (Throwable t) {
                    if (this.failOnCorruptedLogFiles) {
                        Recovery.throwUnableToCleanRecover(t);
                    }
                    if (recoveryContextTracker.hasRecoveredBatches()) {
                        this.monitor.failToRecoverTransactionsAfterCommit(t, recoveryContextTracker.getLastHighestTransactionBatchInfo(), recoveryContextTracker.getRecoveryToPosition());
                    }
                    this.monitor.failToRecoverTransactionsAfterPosition(t, recoveryStartPosition);
                }
                appendIndexProvider = new RecoveryRollbackAppendIndexProvider(recoveryContextTracker.getLastBatchInfo());
                if (!this.rollbackIncompleteTransactions) break block47;
                this.logsTruncator.truncate(recoveryContextTracker.getRecoveryToPosition(), recoveryStartInformation.checkpointInfo());
                RollbackTransactionInfo rollbackTransactionInfo = this.rollbackTransactions(recoveryContextTracker.getRecoveryToPosition(), transactionIdTracker, appendIndexProvider, this.monitor);
                if (rollbackTransactionInfo != null) {
                    recoveryContextTracker.rollbackBatch(rollbackTransactionInfo, rollbackTransactionInfo.position());
                }
            }
            finally {
                this.closeProgress();
            }
        }
        try (CursorContext cursorContext = this.contextFactory.create(RECOVERY_COMPLETED_TAG);){
            boolean missingLogs = recoveryStartInformation.missingLogs();
            this.recoveryService.transactionsRecovered(recoveryContextTracker.getLastHighestTransactionBatchInfo(), appendIndexProvider, recoveryContextTracker.getLastTransactionPosition(), recoveryContextTracker.getRecoveryToPosition(), recoveryStartInformation.getCheckpointPosition(), missingLogs, cursorContext);
        }
        this.monitor.transactionLogRecoveryCompleted(recoveryStartTime.elapsed(TimeUnit.MILLISECONDS), this.mode);
    }

    private RollbackTransactionInfo rollbackTransactions(LogPosition writePosition, TransactionIdTracker transactionTracker, AppendIndexProvider appendIndexProvider, RecoveryMonitor monitor) throws IOException {
        long[] notCompletedTransactions = transactionTracker.notCompletedTransactions();
        if (notCompletedTransactions.length == 0) {
            return null;
        }
        KernelVersion kernelVersion = this.versionProvider.kernelVersion();
        LogFile logFile = this.logFiles.getLogFile();
        PhysicalLogVersionedStoreChannel channel = logFile.createLogChannelForExistingVersion(writePosition.getLogVersion());
        LogHeader logHeader = logFile.extractHeader(writePosition.getLogVersion());
        channel.position(writePosition.getByteOffset());
        try (PhysicalFlushableLogPositionAwareChannel writerChannel = new PhysicalFlushableLogPositionAwareChannel((LogVersionedStoreChannel)channel, logHeader, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            LogEntryWriter<PhysicalFlushableLogPositionAwareChannel> entryWriter = new LogEntryWriter<PhysicalFlushableLogPositionAwareChannel>(writerChannel, this.binarySupportedKernelVersions);
            long time = this.clock.millis();
            CommittedCommandBatchRepresentation.BatchInformation lastBatchInfo = null;
            for (int i = 0; i < notCompletedTransactions.length; ++i) {
                long notCompletedTransaction = notCompletedTransactions[i];
                long appendIndex = appendIndexProvider.nextAppendIndex();
                int checksum = entryWriter.writeRollbackEntry(kernelVersion, notCompletedTransaction, appendIndex, time);
                if (i == notCompletedTransactions.length - 1) {
                    lastBatchInfo = new CommittedCommandBatchRepresentation.BatchInformation(notCompletedTransaction, kernelVersion, checksum, time, -1L, appendIndex);
                }
                monitor.rollbackTransaction(notCompletedTransaction, appendIndex);
            }
            RollbackTransactionInfo rollbackTransactionInfo = new RollbackTransactionInfo(lastBatchInfo, writerChannel.getCurrentLogPosition());
            return rollbackTransactionInfo;
        }
    }

    private void reverseRecovery(RecoveryStartInformation recoveryStartInformation, TransactionIdTracker transactionIdTracker) throws Exception {
        if (this.mode == RecoveryMode.FORWARD) {
            this.initProgressReporter(recoveryStartInformation, recoveryStartInformation.transactionLogPosition());
            return;
        }
        CommittedCommandBatchRepresentation lastReversedCommandBatch = null;
        LogPosition oldestNotVisibleTransactionLogPosition = recoveryStartInformation.oldestNotVisibleTransactionLogPosition();
        LogPosition checkpointedLogPosition = recoveryStartInformation.transactionLogPosition();
        long lowestRecoveredAppendIndex = recoveryStartInformation.firstAppendIndexAfterLastCheckPoint();
        try (CommandBatchCursor transactionsToRecover = this.recoveryService.getCommandBatchesInReverseOrder(oldestNotVisibleTransactionLogPosition);
             RecoveryApplier recoveryVisitor = this.recoveryService.getRecoveryApplier(TransactionApplicationMode.REVERSE_RECOVERY, this.contextFactory, REVERSE_RECOVERY_TAG);){
            while (transactionsToRecover.next()) {
                this.recoveryStartupChecker.checkIfCanceled();
                CommittedCommandBatchRepresentation commandBatch = (CommittedCommandBatchRepresentation)transactionsToRecover.get();
                if (lastReversedCommandBatch == null) {
                    lastReversedCommandBatch = commandBatch;
                    this.initProgressReporter(recoveryStartInformation, lastReversedCommandBatch, this.mode);
                }
                transactionIdTracker.trackBatch(commandBatch);
                if (TransactionLogsRecovery.shouldReverseBatch(transactionIdTracker, transactionsToRecover, checkpointedLogPosition, commandBatch)) {
                    recoveryVisitor.visit(commandBatch);
                }
                lowestRecoveredAppendIndex = commandBatch.appendIndex();
                this.reportProgress();
            }
        }
        this.monitor.reverseStoreRecoveryCompleted(lowestRecoveredAppendIndex);
    }

    private static boolean shouldReverseBatch(TransactionIdTracker transactionIdTracker, CommandBatchCursor transactionsToRecover, LogPosition checkpointedLogPosition, CommittedCommandBatchRepresentation commandBatch) {
        return transactionsToRecover.position().compareTo(checkpointedLogPosition) >= 0 || TransactionStatus.RECOVERABLE != transactionIdTracker.transactionStatus(commandBatch.txId());
    }

    private void initProgressReporter(RecoveryStartInformation recoveryStartInformation, LogPosition recoveryStartPosition) throws IOException {
        try (CommandBatchCursor transactionsToRecover = this.recoveryService.getCommandBatchesInReverseOrder(recoveryStartPosition);){
            if (transactionsToRecover.next()) {
                CommittedCommandBatchRepresentation commandBatch = (CommittedCommandBatchRepresentation)transactionsToRecover.get();
                this.initProgressReporter(recoveryStartInformation, commandBatch, this.mode);
            }
        }
    }

    private void initProgressReporter(RecoveryStartInformation recoveryStartInformation, CommittedCommandBatchRepresentation lastReversedBatch, RecoveryMode mode) {
        long numberOfBatchesToRecover = TransactionLogsRecovery.estimateNumberOfBatchesToRecover(recoveryStartInformation, lastReversedBatch);
        this.progressListener = this.progressMonitorFactory.singlePart("TransactionLogsRecovery", mode == RecoveryMode.FULL ? numberOfBatchesToRecover * 2L : numberOfBatchesToRecover);
    }

    private void reportProgress() {
        this.progressListener.add(1L);
    }

    private void closeProgress() {
        if (this.progressListener != null) {
            this.progressListener.close();
        }
    }

    private static long estimateNumberOfBatchesToRecover(RecoveryStartInformation recoveryStartInformation, CommittedCommandBatchRepresentation lastReversedCommandBatch) {
        return lastReversedCommandBatch.appendIndex() - recoveryStartInformation.firstAppendIndexAfterLastCheckPoint() + 1L;
    }

    public void start() throws Exception {
        this.schemaLife.start();
    }

    public void stop() throws Exception {
        this.schemaLife.stop();
    }

    public void shutdown() throws Exception {
        this.schemaLife.shutdown();
    }

    private static class RecoveryRollbackAppendIndexProvider
    implements AppendIndexProvider {
        private final MutableLong rollbackIndex;

        public RecoveryRollbackAppendIndexProvider(CommittedCommandBatchRepresentation.BatchInformation lastBatchInfo) {
            this.rollbackIndex = lastBatchInfo == null ? new MutableLong(1L) : new MutableLong(lastBatchInfo.appendIndex());
        }

        public long nextAppendIndex() {
            return this.rollbackIndex.incrementAndGet();
        }

        public long getLastAppendIndex() {
            return this.rollbackIndex.longValue();
        }
    }
}

