/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.NoSuchLogEntryException;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryChunkStart;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryRollback;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;

public class AppendedChunkPositionLocator
implements LogFile.LogFileVisitor {
    private final long appendIndex;
    private final LogEntryReader logEntryReader;
    private LogPosition position;

    public AppendedChunkPositionLocator(long appendIndex, LogEntryReader logEntryReader) {
        this.appendIndex = appendIndex;
        this.logEntryReader = logEntryReader;
    }

    @Override
    public boolean visit(ReadableLogPositionAwareChannel channel) throws IOException {
        LogEntry logEntry;
        LogPosition lastStartPosition = null;
        block6: do {
            LogPosition logPosition = channel.getCurrentLogPosition();
            logEntry = this.logEntryReader.readLogEntry(channel);
            if (logEntry == null) continue;
            switch (logEntry.getType()) {
                case 1: {
                    if (!(logEntry instanceof LogEntryStart)) continue block6;
                    LogEntryStart entryStart = (LogEntryStart)logEntry;
                    if (entryStart.kernelVersion().isAtLeast(KernelVersion.VERSION_APPEND_INDEX_INTRODUCED) && entryStart.getAppendIndex() == this.appendIndex) {
                        this.position = logPosition;
                        return false;
                    }
                    lastStartPosition = logPosition;
                    break;
                }
                case 10: {
                    LogEntryChunkStart chunkStart;
                    if (!(logEntry instanceof LogEntryChunkStart) || (chunkStart = (LogEntryChunkStart)logEntry).getAppendIndex() != this.appendIndex) continue block6;
                    this.position = logPosition;
                    return false;
                }
                case 12: {
                    LogEntryRollback rollback;
                    if (!(logEntry instanceof LogEntryRollback) || (rollback = (LogEntryRollback)logEntry).getAppendIndex() != this.appendIndex) continue block6;
                    this.position = logPosition;
                    return false;
                }
                case 5: {
                    LogEntryCommit commit;
                    if (!(logEntry instanceof LogEntryCommit) || !(commit = (LogEntryCommit)logEntry).kernelVersion().isLessThan(KernelVersion.VERSION_APPEND_INDEX_INTRODUCED) || commit.getTxId() != this.appendIndex) continue block6;
                    this.position = lastStartPosition;
                    return false;
                }
            }
        } while (logEntry != null);
        this.position = channel.getCurrentLogPosition();
        return true;
    }

    public LogPosition getLogPositionOrThrow() throws NoSuchLogEntryException {
        if (this.position == null) {
            throw new NoSuchLogEntryException(this.appendIndex);
        }
        return this.position;
    }
}

