/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query.clientconnection;

import java.net.SocketAddress;
import java.util.Map;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;

public class BoltConnectionInfo
extends ClientConnectionInfo {
    private final String connectionId;
    private final String clientName;
    private final SocketAddress clientAddress;
    private final SocketAddress serverAddress;
    private final Map<String, String> boltAgent;

    public BoltConnectionInfo(String connectionId, String clientName, SocketAddress clientAddress, SocketAddress serverAddress, Map<String, String> boltAgent) {
        this.connectionId = connectionId;
        this.clientName = clientName;
        this.clientAddress = clientAddress;
        this.serverAddress = serverAddress;
        this.boltAgent = boltAgent;
    }

    public String asConnectionDetails() {
        return "bolt-session\tbolt\t" + this.clientName + "\t\tclient" + this.clientAddress + "\tserver" + this.serverAddress + ">";
    }

    public String protocol() {
        return "bolt";
    }

    public String connectionId() {
        return this.connectionId;
    }

    public String clientAddress() {
        return org.neo4j.configuration.helpers.SocketAddress.format((SocketAddress)this.clientAddress);
    }

    public String requestURI() {
        return org.neo4j.configuration.helpers.SocketAddress.format((SocketAddress)this.serverAddress);
    }

    public Map<String, String> boltAgent() {
        return this.boltAgent;
    }
}

