/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.Collections;
import java.util.Set;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.NotificationCategory;
import org.neo4j.graphdb.SeverityLevel;

public record NotificationConfiguration(Severity severityLevel, Set<Category> disabledCategories) {
    public static final NotificationConfiguration DEFAULT_FILTER = NotificationConfiguration.all();
    public static final NotificationConfiguration NONE = NotificationConfiguration.none();

    public static NotificationConfiguration all() {
        return new NotificationConfiguration(Severity.INFORMATION, Collections.emptySet());
    }

    public static NotificationConfiguration none() {
        return new NotificationConfiguration(Severity.NONE, Collections.emptySet());
    }

    public boolean includes(Notification notification) {
        return this.includesSeverityLevel(notification.getSeverity()) && !this.disabledNotificationCategory(notification.getCategory());
    }

    private boolean disabledNotificationCategory(NotificationCategory notificationCategory) {
        Category category = switch (notificationCategory) {
            default -> throw new IncompatibleClassChangeError();
            case NotificationCategory.PERFORMANCE -> Category.PERFORMANCE;
            case NotificationCategory.DEPRECATION -> Category.DEPRECATION;
            case NotificationCategory.UNRECOGNIZED -> Category.UNRECOGNIZED;
            case NotificationCategory.HINT -> Category.HINT;
            case NotificationCategory.GENERIC -> Category.GENERIC;
            case NotificationCategory.UNSUPPORTED -> Category.UNSUPPORTED;
            case NotificationCategory.SECURITY -> Category.SECURITY;
            case NotificationCategory.TOPOLOGY -> Category.TOPOLOGY;
            case NotificationCategory.SCHEMA -> Category.SCHEMA;
            case NotificationCategory.UNKNOWN -> null;
        };
        return category != null && this.disabledCategories.contains((Object)category);
    }

    private boolean includesSeverityLevel(SeverityLevel severityLevel) {
        return switch (this.severityLevel) {
            default -> throw new IncompatibleClassChangeError();
            case Severity.INFORMATION -> true;
            case Severity.NONE -> false;
            case Severity.WARNING -> severityLevel.equals((Object)SeverityLevel.WARNING);
        };
    }

    public static enum Severity {
        INFORMATION,
        WARNING,
        NONE;

    }

    public static enum Category {
        HINT,
        UNRECOGNIZED,
        UNSUPPORTED,
        PERFORMANCE,
        DEPRECATION,
        GENERIC,
        SECURITY,
        TOPOLOGY,
        SCHEMA;

    }
}

