/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

final class SortedMergeJoin {
    private static final int NO_ENTITY = -1;
    private long nextFromA = -1L;
    private long nextFromB = -1L;
    private Value[] valuesFromA;
    private Value[] valuesFromB;
    private int indexOrder;

    SortedMergeJoin() {
    }

    void initialize(IndexOrder indexOrder) {
        this.indexOrder = indexOrder == IndexOrder.DESCENDING ? 1 : -1;
        this.nextFromA = -1L;
        this.nextFromB = -1L;
        this.valuesFromA = null;
        this.valuesFromB = null;
    }

    boolean needsA() {
        return this.nextFromA == -1L;
    }

    boolean needsB() {
        return this.nextFromB == -1L;
    }

    void setA(long entityId, Value[] values) {
        this.nextFromA = entityId;
        this.valuesFromA = values;
    }

    void setB(long entityId, Value[] values) {
        this.nextFromB = entityId;
        this.valuesFromB = values;
    }

    boolean next(Sink sink) {
        int c = 0;
        if (this.valuesFromA != null && this.valuesFromB != null) {
            Preconditions.checkArgument((this.valuesFromA.length == this.valuesFromB.length ? 1 : 0) != 0, (String)"Expected index and txState values to have same dimensions, but got %d values from index and %d from txState", (Object[])new Object[]{this.valuesFromB.length, this.valuesFromA.length});
            for (int i = 0; c == 0 && i < this.valuesFromA.length; ++i) {
                c = Values.COMPARATOR.compare(this.valuesFromA[i], this.valuesFromB[i]);
            }
        }
        if (this.nextFromB == -1L || Integer.signum(c) == this.indexOrder) {
            if (this.nextFromA == -1L) {
                return false;
            }
            sink.acceptSortedMergeJoin(this.nextFromA, this.valuesFromA);
            this.nextFromA = -1L;
            this.valuesFromA = null;
        } else {
            sink.acceptSortedMergeJoin(this.nextFromB, this.valuesFromB);
            this.nextFromB = -1L;
            this.valuesFromB = null;
        }
        return true;
    }

    static interface Sink {
        public void acceptSortedMergeJoin(long var1, Value[] var3);
    }
}

