/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.parallel;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextNode;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextRelationship;
import org.neo4j.kernel.impl.util.BaseCoreAPIPath;
import org.neo4j.kernel.impl.util.NodeEntityWrappingNodeValue;
import org.neo4j.kernel.impl.util.PathWrappingPathValue;
import org.neo4j.kernel.impl.util.RelationshipEntityWrappingValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public class ExecutionContextValueMapper
extends ValueMapper.JavaMapper {
    private final ExecutionContext executionContext;

    public ExecutionContextValueMapper(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public Object mapPath(VirtualPathValue value) {
        if (value instanceof PathWrappingPathValue) {
            PathWrappingPathValue wrapper = (PathWrappingPathValue)value;
            return wrapper.path();
        }
        return new ExecutionContextPath(value);
    }

    public Object mapNode(VirtualNodeValue value) {
        if (value instanceof NodeEntityWrappingNodeValue) {
            NodeEntityWrappingNodeValue wrapper = (NodeEntityWrappingNodeValue)value;
            return wrapper.getEntity();
        }
        return new ExecutionContextNode(value.id(), this.executionContext);
    }

    public Object mapRelationship(VirtualRelationshipValue value) {
        if (value instanceof RelationshipEntityWrappingValue) {
            RelationshipEntityWrappingValue wrapper = (RelationshipEntityWrappingValue)value;
            return wrapper.getEntity();
        }
        return new ExecutionContextRelationship(value.id(), this.executionContext);
    }

    public class ExecutionContextPath
    extends BaseCoreAPIPath {
        private ExecutionContextPath(VirtualPathValue value) {
            super(value);
        }

        @Override
        protected Node mapNode(long value) {
            return new ExecutionContextNode(value, ExecutionContextValueMapper.this.executionContext);
        }

        @Override
        protected Relationship mapRelationship(long value) {
            return new ExecutionContextRelationship(value, ExecutionContextValueMapper.this.executionContext);
        }
    }
}

