/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions;

import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlException;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.utils.PrettyPrinter;
import org.neo4j.values.virtual.MapValue;

public class InvalidArgumentsException
extends GqlException
implements Status.HasStatus {
    private final Status status = Status.General.InvalidArguments;

    @Deprecated
    public InvalidArgumentsException(String message) {
        this(message, null);
    }

    public InvalidArgumentsException(ErrorGqlStatusObject gqlStatusObject, String message) {
        this(gqlStatusObject, message, null);
    }

    @Deprecated
    public InvalidArgumentsException(String message, Throwable cause) {
        super(message, cause);
    }

    public InvalidArgumentsException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        super(gqlStatusObject, message, cause);
    }

    public static InvalidArgumentsException requiresPositiveInteger(String option, int value) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22003).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N02).withParam(GqlParams.StringParam.option, option).withParam(GqlParams.NumberParam.value, (Number)value).build()).build();
        return new InvalidArgumentsException(gql, String.format("Option `%s` requires positive integer argument, got `%d`", option, value));
    }

    public static InvalidArgumentsException invalidResource(String typeString) {
        String gqlMsg = String.format("Found invalid resource (%s) in the system graph.", typeString);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)InvalidArgumentsException.class.getSimpleName(), (String)gqlMsg);
        return new InvalidArgumentsException(gql, String.format("Found not valid resource (%s) in the system graph.", typeString));
    }

    public static InvalidArgumentsException entityResourceInvalidAction(String entity, String action, String legacyFormat) {
        String msg = String.format("%s resource cannot be combined with action %s%s%s", entity, legacyFormat, action, legacyFormat);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)InvalidArgumentsException.class.getSimpleName(), (String)msg);
        return new InvalidArgumentsException(gql, msg);
    }

    public static InvalidArgumentsException internalAlterServer(String name) {
        String msg = String.format("Server '%s' can't be altered: must specify options", name);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)InvalidArgumentsException.class.getSimpleName(), (String)msg);
        return new InvalidArgumentsException(gql, msg);
    }

    public Status status() {
        return this.status;
    }

    private static ErrorGqlStatusObject getIdxGql(MapValue itemsMap, List<String> validConfigSettingNames) {
        PrettyPrinter prettyVal = new PrettyPrinter();
        itemsMap.writeTo((AnyValueWriter)prettyVal);
        return GqlHelper.getGql42001_22N04((String)prettyVal.value(), (String)"config options", validConfigSettingNames);
    }

    protected static String invalidConfigValueString(PrettyPrinter pp, AnyValue value, String schemaType) {
        value.writeTo((AnyValueWriter)pp);
        return InvalidArgumentsException.invalidConfigValueString(pp.value(), schemaType);
    }

    protected static String invalidConfigValueString(String value, String schemaType) {
        return String.format("Could not create %s with specified index config '%s'", schemaType, value);
    }

    public static InvalidArgumentsException pointOptionsInConfig(PrettyPrinter pp, MapValue itemsMap, String schemaType, List<String> validConfigSettingNames) {
        ErrorGqlStatusObject gql = InvalidArgumentsException.getIdxGql(itemsMap, validConfigSettingNames);
        return new InvalidArgumentsException(gql, String.format("%s, contains spatial config settings options.\nTo create point index, please use 'CREATE POINT INDEX ...'.", InvalidArgumentsException.invalidConfigValueString(pp, (AnyValue)itemsMap, schemaType)));
    }

    public static InvalidArgumentsException fulltextOptionsInConfig(PrettyPrinter pp, MapValue itemsMap, String schemaType, List<String> validConfigSettingNames) {
        ErrorGqlStatusObject gql = InvalidArgumentsException.getIdxGql(itemsMap, validConfigSettingNames);
        return new InvalidArgumentsException(gql, String.format("%s, contains fulltext config options.\nTo create fulltext index, please use 'CREATE FULLTEXT INDEX ...'.", InvalidArgumentsException.invalidConfigValueString(pp, (AnyValue)itemsMap, schemaType)));
    }

    public static InvalidArgumentsException vectorOptionsInConfig(PrettyPrinter pp, MapValue itemsMap, String schemaType, List<String> validConfigSettingNames) {
        ErrorGqlStatusObject gql = InvalidArgumentsException.getIdxGql(itemsMap, validConfigSettingNames);
        return new InvalidArgumentsException(gql, String.format("%s, contains vector config options.\nTo create vector index, please use 'CREATE VECTOR INDEX ...'.", InvalidArgumentsException.invalidConfigValueString(pp, (AnyValue)itemsMap, schemaType)));
    }

    public static InvalidArgumentsException expectedNonePrimarySecondary(String value, String modeConstraint, List<String> expected) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)value, (String)modeConstraint, expected);
        return new InvalidArgumentsException(gql, String.format("%s expects 'NONE', 'PRIMARY' or 'SECONDARY' but got '%s'.", modeConstraint, value));
    }

    public static InvalidArgumentsException unrecognisedOptionGivenValue(String operation, String value, String key, String validValue, Boolean formatValidValuesForOld) {
        List<String> validValues = List.of(validValue);
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)value, (String)key, validValues);
        if (formatValidValuesForOld.booleanValue()) {
            validValue = "'" + (String)validValue + "'";
        }
        return new InvalidArgumentsException(gql, String.format("Could not %s with specified %s '%s'. Expected %s.", operation, key, value, validValue));
    }

    public static InvalidArgumentsException unrecognisedOptionGivenValue(String operation, String key, String value, List<String> validValues) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)value, (String)key, validValues);
        String validValuesString = validValues.stream().map(option -> "'" + option + "'").collect(Collectors.joining(", "));
        return new InvalidArgumentsException(gql, String.format("Could not %s with specified %s '%s', Expected one of %s.", operation, key, value, validValuesString));
    }

    public static InvalidArgumentsException unrecognisedOptionsOnlyKeys(String operation, String invalidKeys, List<String> permittedOptions) {
        String permittedOptionsString = String.join((CharSequence)", ", permittedOptions);
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)invalidKeys, (String)GqlParams.StringParam.input.process((Object)"OPTIONS"), permittedOptions);
        return new InvalidArgumentsException(gql, String.format("Could not %s with unrecognised option(s): %s. Expected %s.", operation, invalidKeys, permittedOptionsString));
    }

    public static InvalidArgumentsException unrecognisedOptionsNoOperation(String invalidKey, List<String> permittedOptions) {
        String permittedOptionsString = permittedOptions.stream().map(option -> "'" + option + "'").collect(Collectors.joining(", "));
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)invalidKey, (String)GqlParams.StringParam.input.process((Object)"OPTIONS"), permittedOptions);
        return new InvalidArgumentsException(gql, String.format("Unrecognised option '%s', expected %s.", invalidKey, permittedOptionsString));
    }

    public static InvalidArgumentsException unrecognisedCreateDbOptions(String operation, String invalidKeys, List<String> permittedOptions) {
        String permittedOptionsString = String.join((CharSequence)", ", permittedOptions);
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)invalidKeys, (String)GqlParams.StringParam.input.process((Object)"OPTIONS"), permittedOptions);
        return new InvalidArgumentsException(gql, String.format("Could not %s with 'CREATE DATABASE' option(s): %s. Expected %s.", operation, invalidKeys, permittedOptionsString));
    }

    public static InvalidArgumentsException invalidDriverSettings(String operation, String invalidKeys, List<String> validKeys) {
        String validKeysString = String.join((CharSequence)", ", validKeys);
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)invalidKeys, (String)GqlParams.StringParam.input.process((Object)"DRIVER"), validKeys);
        return new InvalidArgumentsException(gql, String.format("Failed to %s: Invalid driver setting(s) provided: %s. Valid driver settings are: %s", operation, invalidKeys, validKeysString));
    }

    public static InvalidArgumentsException unexpectedDriverSettingValue(String operation, String value, String settingKey, List<String> validValues) {
        String validValuesString = String.join((CharSequence)", ", validValues);
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)value, (String)GqlParams.StringParam.input.process((Object)"DRIVER"), validValues);
        return new InvalidArgumentsException(gql, String.format("Failed to %s: Invalid driver settings value for '%s'. Expected one of %s.", operation, settingKey, validValuesString));
    }

    public static InvalidArgumentsException invalidOptionFormat(String operation, String key, String value, List<String> validFormats) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)value, (String)key, validFormats);
        String validFormatsString = validFormats.stream().map(format -> "'" + format + "'").collect(Collectors.joining(", "));
        return new InvalidArgumentsException(gql, String.format("Could not %s with specified %s '%s'. Unknown format, supported formats are %s", operation, key, value, validFormatsString));
    }

    public static InvalidArgumentsException invalidIndexOptionValue(String providedOption, String schemaType) {
        List<String> validOptions = List.of("indexProvider", "indexConfig");
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)providedOption, (String)GqlParams.StringParam.input.process((Object)"OPTIONS"), validOptions);
        return new InvalidArgumentsException(gql, String.format("Failed to create %s: Invalid option provided, valid options are `indexProvider` and `indexConfig`.", schemaType));
    }

    public static InvalidArgumentsException invalidIndexConfig(String schemaType, String indexConfigOptions, String indexType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)"indexConfig", (String)"config option", List.of("indexProvider"));
        return new InvalidArgumentsException(gql, String.format("Could not create %s with specified index config '%s': %s indexes have no valid config values.", schemaType, indexConfigOptions, indexType));
    }

    public static InvalidArgumentsException invalidIndexProviderSuggestIndex(String schemaDescription, String providerString, String indexDescription, String providerIndexType, List<String> indexProviders) {
        String indexProvidersString = "[" + indexProviders.stream().map(format -> "'" + format + "'").collect(Collectors.joining(", ")) + "]";
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)providerString, (String)"index provider type", indexProviders);
        return new InvalidArgumentsException(gql, String.format("Could not create %s with specified index provider '%s'.\nTo create %s index, please use 'CREATE %s INDEX ...'.\nThe available index providers for the given type: %s.", schemaDescription, providerString, indexDescription, providerIndexType, indexProvidersString));
    }

    public static InvalidArgumentsException invalidIndexProvider(Boolean correctCypherVersion, String schemaDescription, String providerString, List<String> indexProviders) {
        String indexProvidersString = "[" + indexProviders.stream().map(format -> "'" + format + "'").collect(Collectors.joining(", ")) + "]";
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)providerString, (String)"index provider type", indexProviders);
        String message = correctCypherVersion != false && (providerString.equalsIgnoreCase("native-btree-1.0") || providerString.equalsIgnoreCase("lucene+native-3.0")) ? String.format("Could not create %s with specified index provider '%s'.\nInvalid index type b-tree, use range, point or text index instead.\nThe available index providers for the given type: %s.", schemaDescription, providerString, indexProvidersString) : String.format("Could not create %s with specified index provider '%s'.\nThe available index providers for the given type: %s.", schemaDescription, providerString, indexProvidersString);
        return new InvalidArgumentsException(gql, message);
    }

    public static InvalidArgumentsException compositeUsingOptions(String operation) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N81((String)GqlParams.StringParam.cmd.process((Object)"OPTIONS"), (String)GqlParams.StringParam.cmd.process((Object)"CREATE COMPOSITE DATABASE"));
        return new InvalidArgumentsException(gql, String.format("Could not %s: composite databases have no valid options values.", operation));
    }

    public static InvalidArgumentsException noValidPropertyConstraintOptions(String entity, String constraintType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N81((String)GqlParams.StringParam.cmd.process((Object)"OPTIONS"), (String)String.format("%s property %s constraints", entity, constraintType));
        return new InvalidArgumentsException(gql, String.format("Could not create %s property %s constraint: property %s constraints have no valid options values.", entity, constraintType, constraintType));
    }

    public static InvalidArgumentsException connectionPoolSizeZeroNotAllowed(String operation, String pool_max_size) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N05).withParam(GqlParams.StringParam.input, "0").withParam(GqlParams.StringParam.context, operation).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N86).build()).build();
        return new InvalidArgumentsException(gql, String.format("Failed to %s: Invalid driver settings value for '%s'. Zero is not allowed.", operation, pool_max_size));
    }

    public static InvalidArgumentsException optionRequiresInteger(String option, Object value) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N27((String)option, (String)value.getClass().getTypeName(), List.of("INTEGER"));
        return new InvalidArgumentsException(gql, String.format("Option `%s` requires integer argument, got `%s`", option, value));
    }

    public static InvalidArgumentsException inputContainsInvalidCharacters(String invalidInput, String context, String legacyMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N05).withParam(GqlParams.StringParam.input, invalidInput).withParam(GqlParams.StringParam.context, context).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N82).withParam(GqlParams.StringParam.input, invalidInput).withParam(GqlParams.StringParam.context, context).build()).build();
        return new InvalidArgumentsException(gql, legacyMessage);
    }
}

