/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.AbstractSwallowingIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxyStrategy;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.values.storable.Value;

public class FailedIndexProxy
extends AbstractSwallowingIndexProxy {
    private final IndexProxyStrategy indexProxyStrategy;
    private final MinimalIndexAccessor minimalIndexAccessor;
    private final InternalLog log;

    FailedIndexProxy(IndexProxyStrategy indexProxyStrategy, MinimalIndexAccessor minimalIndexAccessor, IndexPopulationFailure populationFailure, InternalLogProvider logProvider) {
        super(indexProxyStrategy.getIndexDescriptor(), populationFailure);
        this.indexProxyStrategy = indexProxyStrategy;
        this.minimalIndexAccessor = minimalIndexAccessor;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public void start() {
    }

    public void drop() {
        this.indexProxyStrategy.removeStatisticsForIndex();
        String message = "FailedIndexProxy#drop index on " + this.indexProxyStrategy.getIndexUserDescription() + " dropped due to:\n" + this.getPopulationFailure().asString();
        this.log.info(message);
        this.minimalIndexAccessor.drop();
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.FAILED;
    }

    @Override
    public boolean awaitStoreScanCompleted(long time, TimeUnit unit) throws IndexPopulationFailedKernelException {
        throw this.failureCause();
    }

    private IndexPopulationFailedKernelException failureCause() {
        return this.getPopulationFailure().asIndexPopulationFailure(this.getDescriptor().schema(), this.indexProxyStrategy.getIndexUserDescription());
    }

    @Override
    public void activate() {
        throw new UnsupportedOperationException("Cannot activate a failed index.");
    }

    @Override
    public void validate() throws IndexPopulationFailedKernelException {
        throw this.failureCause();
    }

    @Override
    public void validateBeforeCommit(Value[] tuple, long entityId) {
    }

    public ResourceIterator<Path> snapshotFiles() throws IOException {
        return this.minimalIndexAccessor.snapshotFiles();
    }

    public Map<String, Value> indexConfig() {
        return this.minimalIndexAccessor.indexConfig();
    }

    @Override
    public ValueIndexReader newValueReader() {
        throw new UnsupportedOperationException("Can not get a reader for an index in FAILED state");
    }

    @Override
    public TokenIndexReader newTokenReader() {
        throw new UnsupportedOperationException("Can not get a reader for an index in FAILED state");
    }
}

