/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.function.BooleanSupplier;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.procedure.ProcedureView;
import org.neo4j.token.TokenHolders;

class TokenHoldersIdLookup
implements LoginContext.IdLookup {
    private final TokenHolders tokens;
    private final ProcedureView view;
    private final BooleanSupplier isStale;

    TokenHoldersIdLookup(TokenHolders tokens, ProcedureView view, BooleanSupplier isStale) {
        this.tokens = tokens;
        this.view = view;
        this.isStale = isStale;
    }

    public int getPropertyKeyId(String name) {
        return this.tokens.propertyKeyTokens().getIdByName(name);
    }

    public int getLabelId(String name) {
        return this.tokens.labelTokens().getIdByName(name);
    }

    public int getRelTypeId(String name) {
        return this.tokens.relationshipTypeTokens().getIdByName(name);
    }

    public int[] getProcedureIds(String procedureGlobbing) {
        return this.view.getProcedureIds(procedureGlobbing);
    }

    public int[] getAdminProcedureIds() {
        return this.view.getAdminProcedureIds();
    }

    public int[] getFunctionIds(String functionGlobbing) {
        return this.view.getFunctionIds(functionGlobbing);
    }

    public int[] getAggregatingFunctionIds(String functionGlobbing) {
        return this.view.getAggregatingFunctionIds(functionGlobbing);
    }

    public boolean isCachableLookup() {
        return true;
    }

    public boolean isStale() {
        return this.isStale.getAsBoolean();
    }
}

