/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.DbmsRuntimeVersionProvider;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;

public class DbmsRuntimeFallbackKernelVersionProvider
implements KernelVersionProvider {
    private final KernelVersionProvider kernelVersionProvider;

    public DbmsRuntimeFallbackKernelVersionProvider(Dependencies dependencies, String databaseName, Config config) {
        if (dependencies.containsDependency(KernelVersionProvider.class)) {
            this.kernelVersionProvider = (KernelVersionProvider)dependencies.resolveDependency(KernelVersionProvider.class);
        } else if ("system".equals(databaseName) || !dependencies.containsDependency(DbmsRuntimeVersionProvider.class)) {
            this.kernelVersionProvider = DbmsRuntimeVersion.getLatestVersion(config);
        } else {
            DbmsRuntimeVersionProvider dbmsRuntimeVersionProvider = (DbmsRuntimeVersionProvider)dependencies.resolveDependency(DbmsRuntimeVersionProvider.class);
            this.kernelVersionProvider = () -> dbmsRuntimeVersionProvider.getVersion().kernelVersion();
        }
    }

    public KernelVersion kernelVersion() {
        return this.kernelVersionProvider.kernelVersion();
    }
}

