/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.NonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NullValue;

class FullScanNonUniqueIndexSampler<KEY extends NativeIndexKey<KEY>>
extends NonUniqueIndexSampler.Adapter {
    private final GBPTree<KEY, NullValue> gbpTree;
    private final IndexLayout<KEY> layout;

    FullScanNonUniqueIndexSampler(GBPTree<KEY, NullValue> gbpTree, IndexLayout<KEY> layout) {
        this.gbpTree = gbpTree;
        this.layout = layout;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexSample sample(CursorContext cursorContext, AtomicBoolean stopped) {
        NativeIndexKey lowest = (NativeIndexKey)((Object)this.layout.newKey());
        lowest.initialize(Long.MIN_VALUE);
        lowest.initValuesAsLowest();
        NativeIndexKey highest = (NativeIndexKey)((Object)this.layout.newKey());
        highest.initialize(Long.MAX_VALUE);
        highest.initValuesAsHighest();
        NativeIndexKey prev = (NativeIndexKey)((Object)this.layout.newKey());
        try (Seeker seek = this.gbpTree.seek((Object)lowest, (Object)highest, cursorContext);){
            long sampledValues = 0L;
            long uniqueValues = 0L;
            if (seek.next()) {
                prev = (NativeIndexKey)((Object)this.layout.copyKey((Object)((NativeIndexKey)((Object)seek.key())), (Object)prev));
                ++sampledValues;
                ++uniqueValues;
                while (seek.next()) {
                    if (stopped.get()) {
                        IndexSample indexSample = new IndexSample();
                        return indexSample;
                    }
                    if (this.layout.compareValue(prev, (NativeIndexKey)((Object)seek.key())) != 0) {
                        ++uniqueValues;
                        this.layout.copyKey((Object)((NativeIndexKey)((Object)seek.key())), (Object)prev);
                    }
                    ++sampledValues;
                }
            }
            IndexSample indexSample = new IndexSample(sampledValues, uniqueValues, sampledValues);
            return indexSample;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public IndexSample sample(int numDocs, CursorContext cursorContext) {
        throw new UnsupportedOperationException();
    }
}

