/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.LongFunction;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.configuration.Config;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.ExecutionSupervisors;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityIdIterator;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityScanCursorBehaviour;
import org.neo4j.kernel.impl.transaction.state.storeview.StoreScanStage;
import org.neo4j.lock.Lock;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEntityScanCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public abstract class PropertyAwareEntityStoreScan<CURSOR extends StorageEntityScanCursor<?>>
implements StoreScan {
    protected final StorageReader storageReader;
    private final Function<CursorContext, StoreCursors> storeCursorsFactory;
    protected final EntityScanCursorBehaviour<CURSOR> cursorBehaviour;
    private final boolean parallelWrite;
    private final JobScheduler scheduler;
    protected final PageCacheTracer cacheTracer;
    private final AtomicBoolean continueScanning = new AtomicBoolean();
    private final long totalCount;
    private final MemoryTracker memoryTracker;
    protected final int[] entityTokenIdFilter;
    private final IntPredicate propertyKeyIdFilter;
    private final LongFunction<Lock> lockFunction;
    private final Config dbConfig;
    private PhaseTracker phaseTracker;
    protected final TokenScanConsumer tokenScanConsumer;
    protected final PropertyScanConsumer propertyScanConsumer;
    private volatile StoreScanStage<CURSOR> stage;

    protected PropertyAwareEntityStoreScan(Config config, StorageReader storageReader, Function<CursorContext, StoreCursors> storeCursorsFactory, long totalEntityCount, int[] entityTokenIdFilter, IntPredicate propertyKeyIdFilter, PropertyScanConsumer propertyScanConsumer, TokenScanConsumer tokenScanConsumer, LongFunction<Lock> lockFunction, EntityScanCursorBehaviour<CURSOR> cursorBehaviour, boolean parallelWrite, JobScheduler scheduler, PageCacheTracer cacheTracer, MemoryTracker memoryTracker) {
        this.storageReader = storageReader;
        this.storeCursorsFactory = storeCursorsFactory;
        this.cursorBehaviour = cursorBehaviour;
        this.parallelWrite = parallelWrite;
        this.scheduler = scheduler;
        this.cacheTracer = cacheTracer;
        this.entityTokenIdFilter = entityTokenIdFilter;
        this.propertyKeyIdFilter = propertyKeyIdFilter;
        this.lockFunction = lockFunction;
        this.totalCount = totalEntityCount;
        this.memoryTracker = memoryTracker;
        this.phaseTracker = PhaseTracker.nullInstance;
        this.tokenScanConsumer = tokenScanConsumer;
        this.propertyScanConsumer = propertyScanConsumer;
        this.dbConfig = config;
    }

    @Override
    public void run(StoreScan.ExternalUpdatesCheck externalUpdatesCheck) {
        try {
            this.continueScanning.set(true);
            this.stage = new StoreScanStage<CURSOR>(this.dbConfig, Configuration.DEFAULT, this::getEntityIdIterator, externalUpdatesCheck, this.continueScanning, this.storageReader, this.storeCursorsFactory, this.entityTokenIdFilter, this.propertyKeyIdFilter, this.propertyScanConsumer, this.tokenScanConsumer, this.cursorBehaviour, this.lockFunction, this.parallelWrite, this.scheduler, this.cacheTracer, this.memoryTracker);
            ExecutionSupervisors.superviseDynamicExecution((ExecutionMonitor)ExecutionMonitor.INVISIBLE, this.stage);
            this.stage.reportTo(this.phaseTracker);
        }
        catch (Throwable throwable) {
            IOUtils.closeAllUnchecked((AutoCloseable[])new StorageReader[]{this.storageReader});
            throw throwable;
        }
        IOUtils.closeAllUnchecked((AutoCloseable[])new StorageReader[]{this.storageReader});
    }

    @Override
    public void stop() {
        this.continueScanning.set(false);
    }

    @Override
    public PopulationProgress getProgress() {
        StoreScanStage<CURSOR> observedStage = this.stage;
        if (this.totalCount > 0L || observedStage == null) {
            return PopulationProgress.single((long)(observedStage != null ? observedStage.numberOfIteratedEntities() : 0L), (long)this.totalCount);
        }
        return PopulationProgress.DONE;
    }

    @Override
    public void setPhaseTracker(PhaseTracker phaseTracker) {
        this.phaseTracker = phaseTracker;
    }

    public EntityIdIterator getEntityIdIterator(CursorContext cursorContext, StoreCursors storeCursors) {
        return new CursorEntityIdIterator<CURSOR>(this.cursorBehaviour.allocateEntityScanCursor(cursorContext, storeCursors));
    }

    static class CursorEntityIdIterator<CURSOR extends StorageEntityScanCursor<?>>
    extends PrimitiveLongResourceCollections.AbstractPrimitiveLongBaseResourceIterator
    implements EntityIdIterator {
        private final CURSOR entityCursor;

        CursorEntityIdIterator(CURSOR entityCursor) {
            super(() -> entityCursor.close());
            this.entityCursor = entityCursor;
            entityCursor.scan();
        }

        @Override
        public void invalidateCache() {
        }

        protected boolean fetchNext() {
            return this.entityCursor.next() && this.next(this.entityCursor.entityReference());
        }
    }
}

