/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.neo4j.common.Validator;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.util.Preconditions;

public final class Validators {
    public static final Validator<String> REGEX_FILE_EXISTS = fileWithRegexInName -> {
        if (Validators.matchingFiles(fileWithRegexInName).isEmpty()) {
            throw new IllegalArgumentException("File '" + fileWithRegexInName + "' doesn't exist");
        }
    };
    public static final Validator<Path> CONTAINS_EXISTING_DATABASE = dbDir -> {
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            if (!Validators.isExistingDatabase((FileSystemAbstraction)fileSystem, DatabaseLayout.ofFlat((Path)dbDir))) {
                throw new IllegalArgumentException("Directory '" + String.valueOf(dbDir) + "' does not contain a database");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    };

    private Validators() {
    }

    static List<Path> matchingFiles(String fileWithRegexInName) {
        String parentSafeFileName = fileWithRegexInName.replace("\\\\", "__");
        File absoluteParentSafeFile = new File(parentSafeFileName).getAbsoluteFile();
        File parent = absoluteParentSafeFile.getParentFile();
        Preconditions.checkState((parent != null && parent.exists() ? 1 : 0) != 0, (String)"Directory %s of %s doesn't exist", (Object[])new Object[]{parent, fileWithRegexInName});
        int fileNameLength = absoluteParentSafeFile.getAbsolutePath().length() - parent.getAbsolutePath().length() - 1;
        String patternString = fileWithRegexInName.substring(fileWithRegexInName.length() - fileNameLength).replace("\\\\", "\\");
        Pattern pattern = Pattern.compile(patternString);
        ArrayList<Path> paths = new ArrayList<Path>();
        for (File file : parent.listFiles()) {
            if (!pattern.matcher(file.getName()).matches()) continue;
            paths.add(file.toPath());
        }
        return paths;
    }

    public static boolean isExistingDatabase(FileSystemAbstraction fileSystem, DatabaseLayout layout) {
        return fileSystem.fileExists(layout.metadataStore());
    }

    public static <T> Validator<T> emptyValidator() {
        return value -> {};
    }
}

