/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.io.OutputStream;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.logging.Level;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.logging.log4j.LogConfig;
import org.neo4j.logging.log4j.Neo4jLoggerContext;
import org.neo4j.memory.MemoryPools;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.Clocks;

public final class ConfigurableStandalonePageCacheFactory {
    private ConfigurableStandalonePageCacheFactory() {
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, JobScheduler jobScheduler, PageCacheTracer pageCacheTracer) {
        Config config = Config.defaults();
        return ConfigurableStandalonePageCacheFactory.createPageCache(fileSystem, pageCacheTracer, config, jobScheduler, new MemoryPools(((Boolean)config.get(GraphDatabaseSettings.memory_tracking)).booleanValue()));
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, JobScheduler jobScheduler, PageCacheTracer pageCacheTracer) {
        return ConfigurableStandalonePageCacheFactory.createPageCache(fileSystem, pageCacheTracer, config, jobScheduler, new MemoryPools(((Boolean)config.get(GraphDatabaseSettings.memory_tracking)).booleanValue()));
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, PageCacheTracer pageCacheTracer, Config config, JobScheduler jobScheduler, MemoryPools memoryPools) {
        config.setIfNotSet(GraphDatabaseSettings.pagecache_memory, (Object)"8M");
        Neo4jLoggerContext loggerContext = LogConfig.createBuilder((OutputStream)System.err, (Level)Level.INFO).withTimezone((LogTimeZone)config.get(GraphDatabaseSettings.db_timezone)).build();
        try (Log4jLogProvider logProvider = new Log4jLogProvider(loggerContext);){
            ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, config, pageCacheTracer, logProvider.getLog(PageCache.class), jobScheduler, Clocks.nanoClock(), memoryPools);
            PageCache pageCache = pageCacheFactory.getOrCreatePageCache();
            return pageCache;
        }
    }
}

