/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.function.Consumer;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.PrimitiveSortedMergeJoin;
import org.neo4j.kernel.impl.newapi.Read;

abstract class DefaultEntityTokenIndexCursor<SELF extends DefaultEntityTokenIndexCursor<SELF>>
extends IndexCursor<IndexProgressor, SELF>
implements IndexProgressor.EntityTokenClient {
    private Read read;
    private long entity = -1L;
    private TokenSet tokens;
    private LongIterator added;
    private LongSet removed;
    private boolean useMergeSort;
    private final PrimitiveSortedMergeJoin sortedMergeJoin = new PrimitiveSortedMergeJoin();
    private AccessMode accessMode;
    private boolean shortcutSecurity;

    DefaultEntityTokenIndexCursor(CursorPool<SELF> pool) {
        super(pool);
    }

    abstract LongSet createAddedInTxState(TransactionState var1, int var2);

    abstract LongSet createDeletedInTxState(TransactionState var1, int var2);

    abstract void traceScan(KernelReadTracer var1, int var2);

    abstract void traceNext(KernelReadTracer var1, long var2);

    abstract boolean allowedToSeeAllEntitiesWithToken(AccessMode var1, int var2);

    abstract boolean allowedToSeeEntity(AccessMode var1, long var2, TokenSet var4);

    public void initialize(IndexProgressor progressor, int token, IndexOrder order) {
        this.initialize(progressor);
        if (this.read.hasTxStateWithChanges()) {
            LongSet frozenAdded = this.createAddedInTxState(this.read.txState(), token);
            switch (order) {
                case NONE: {
                    this.useMergeSort = false;
                    this.added = frozenAdded.longIterator();
                    break;
                }
                case ASCENDING: 
                case DESCENDING: {
                    this.useMergeSort = true;
                    this.sortedMergeJoin.initialize(order);
                    long[] addedSortedArray = frozenAdded.toSortedArray();
                    this.added = IndexOrder.DESCENDING == order ? PrimitiveLongCollections.reverseIterator((long[])addedSortedArray) : PrimitiveLongCollections.iterator((long[])addedSortedArray);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported index order:" + String.valueOf(order));
                }
            }
            this.removed = this.createDeletedInTxState(this.read.txState(), token);
        } else {
            this.useMergeSort = false;
        }
        if (this.tracer != null) {
            this.traceScan(this.tracer, token);
        }
        this.accessMode = this.read.ktx.securityContext().mode();
        this.initSecurity(token);
    }

    public void initialize(IndexProgressor progressor, int token, LongIterator added, LongSet removed, AccessMode accessMode) {
        this.initialize(progressor);
        this.useMergeSort = false;
        this.added = added;
        this.removed = removed;
        this.accessMode = accessMode;
        this.initSecurity(token);
    }

    public boolean acceptEntity(long reference, TokenSet tokens) {
        if (this.isRemoved(reference) || !this.allowed(reference, tokens)) {
            return false;
        }
        this.entity = reference;
        this.tokens = tokens;
        return true;
    }

    private void initSecurity(int token) {
        this.shortcutSecurity = this.allowedToSeeAllEntitiesWithToken(this.accessMode, token);
    }

    boolean allowed(long reference, TokenSet tokens) {
        return this.shortcutSecurity || this.allowedToSeeEntity(this.accessMode, reference, tokens);
    }

    public boolean next() {
        if (this.useMergeSort) {
            return this.nextWithOrdering();
        }
        return this.nextWithoutOrder();
    }

    private boolean nextWithoutOrder() {
        if (this.added != null && this.added.hasNext()) {
            this.entity = this.added.next();
            if (this.tracer != null) {
                this.traceNext(this.tracer, this.entity);
            }
            return true;
        }
        boolean hasNext = this.innerNext();
        if (this.tracer != null && hasNext) {
            this.traceNext(this.tracer, this.entity);
        }
        return hasNext;
    }

    private boolean nextWithOrdering() {
        boolean next;
        if (this.sortedMergeJoin.needsA() && this.added.hasNext()) {
            long entity = this.added.next();
            this.sortedMergeJoin.setA(entity);
        }
        if (this.sortedMergeJoin.needsB() && this.innerNext()) {
            this.sortedMergeJoin.setB(this.entity);
        }
        this.entity = this.sortedMergeJoin.next();
        boolean bl = next = this.entity != -1L;
        if (this.tracer != null && next) {
            this.traceNext(this.tracer, this.entity);
        }
        return next;
    }

    public void setRead(Read read) {
        this.read = read;
    }

    public long entityReference() {
        return this.entity;
    }

    protected void readEntity(Consumer<Read> entityReader) {
        entityReader.accept(this.read);
    }

    public TokenSet tokens() {
        return this.tokens;
    }

    @Override
    public void closeInternal() {
        if (!this.isClosed()) {
            this.closeProgressor();
            this.entity = -1L;
            this.tokens = null;
            this.read = null;
            this.added = null;
            this.removed = null;
            this.accessMode = null;
        }
        super.closeInternal();
    }

    public boolean isClosed() {
        return this.isProgressorClosed();
    }

    private boolean isRemoved(long reference) {
        return this.removed != null && this.removed.contains(reference);
    }
}

