/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

class FusionIndexUpdater
extends FusionIndexBase<IndexUpdater>
implements IndexUpdater {
    FusionIndexUpdater(SlotSelector slotSelector, LazyInstanceSelector<IndexUpdater> instanceSelector) {
        super(slotSelector, instanceSelector);
    }

    public void process(IndexEntryUpdate<?> update) throws IndexEntryConflictException {
        ValueIndexEntryUpdate valueUpdate = this.asValueUpdate(update);
        switch (valueUpdate.updateMode()) {
            case ADDED: {
                ((IndexUpdater)this.instanceSelector.select(this.slotSelector.selectSlot(valueUpdate.values(), CATEGORY_OF))).process((IndexEntryUpdate)valueUpdate);
                break;
            }
            case CHANGED: {
                IndexUpdater from = (IndexUpdater)this.instanceSelector.select(this.slotSelector.selectSlot(valueUpdate.beforeValues(), CATEGORY_OF));
                IndexUpdater to = (IndexUpdater)this.instanceSelector.select(this.slotSelector.selectSlot(valueUpdate.values(), CATEGORY_OF));
                if (from == to) {
                    from.process((IndexEntryUpdate)valueUpdate);
                    break;
                }
                from.process((IndexEntryUpdate)IndexEntryUpdate.remove((long)valueUpdate.getEntityId(), (SchemaDescriptorSupplier)valueUpdate.indexKey(), (Value[])valueUpdate.beforeValues()));
                to.process((IndexEntryUpdate)IndexEntryUpdate.add((long)valueUpdate.getEntityId(), (SchemaDescriptorSupplier)valueUpdate.indexKey(), (Value[])valueUpdate.values()));
                break;
            }
            case REMOVED: {
                ((IndexUpdater)this.instanceSelector.select(this.slotSelector.selectSlot(valueUpdate.values(), CATEGORY_OF))).process((IndexEntryUpdate)valueUpdate);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update mode");
            }
        }
    }

    public void close() throws IndexEntryConflictException {
        AtomicReference chainedExceptions = new AtomicReference();
        this.instanceSelector.close(indexUpdater -> {
            block2: {
                try {
                    indexUpdater.close();
                }
                catch (IndexEntryConflictException e) {
                    if (chainedExceptions.compareAndSet(null, e)) break block2;
                    ((IndexEntryConflictException)((Object)((Object)chainedExceptions.get()))).addSuppressed((Throwable)e);
                }
            }
        });
        if (chainedExceptions.get() != null) {
            throw (IndexEntryConflictException)((Object)chainedExceptions.get());
        }
    }
}

