/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.ConstraintViolationTransactionFailureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.coreapi.TransactionExceptionMapper;

public class DefaultTransactionExceptionMapper
implements TransactionExceptionMapper {
    private static final String UNABLE_TO_COMPLETE_TRANSACTION = "Unable to complete transaction.";
    public static final DefaultTransactionExceptionMapper INSTANCE = new DefaultTransactionExceptionMapper();

    private DefaultTransactionExceptionMapper() {
    }

    @Override
    public RuntimeException mapException(Exception e) {
        if (e instanceof TransientFailureException) {
            return (TransientFailureException)e;
        }
        if (e instanceof ConstraintViolationTransactionFailureException) {
            return new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof Status.HasStatus) {
            Status status = ((Status.HasStatus)e).status();
            Status.Code statusCode = status.code();
            if (statusCode.classification() == Status.Classification.TransientError) {
                return new TransientTransactionFailureException(status, "Unable to complete transaction.: " + statusCode.description(), (Throwable)e);
            }
            return new TransactionFailureException(UNABLE_TO_COMPLETE_TRANSACTION, (Throwable)e);
        }
        return new TransactionFailureException(UNABLE_TO_COMPLETE_TRANSACTION, (Throwable)e);
    }
}

