/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.context;

import java.util.function.LongSupplier;
import org.neo4j.io.pagecache.context.VersionContext;

public class TransactionVersionContext
implements VersionContext {
    private final LongSupplier lastClosedTxIdSupplier;
    private long transactionId = 1L;
    private long lastClosedTxId = Long.MAX_VALUE;
    private boolean dirty;

    public TransactionVersionContext(LongSupplier lastClosedTxIdSupplier) {
        this.lastClosedTxIdSupplier = lastClosedTxIdSupplier;
    }

    public void initRead() {
        long txId = this.lastClosedTxIdSupplier.getAsLong();
        assert (txId >= 1L);
        this.lastClosedTxId = txId;
        this.dirty = false;
    }

    public void initWrite(long committingTxId) {
        assert (committingTxId >= 1L);
        this.transactionId = committingTxId;
    }

    public long committingTransactionId() {
        return this.transactionId;
    }

    public long lastClosedTransactionId() {
        return this.lastClosedTxId;
    }

    public void markAsDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

