/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.event;

import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.memory.HeapEstimator;

class LabelEntryView
implements LabelEntry {
    static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(LabelEntryView.class);
    private final InternalTransaction internalTransaction;
    private final long nodeId;
    private final Label label;

    LabelEntryView(InternalTransaction internalTransaction, long nodeId, String labelName) {
        this.internalTransaction = internalTransaction;
        this.nodeId = nodeId;
        this.label = Label.label((String)labelName);
    }

    public Label label() {
        return this.label;
    }

    public Node node() {
        return new NodeEntity(this.internalTransaction, this.nodeId);
    }

    public String toString() {
        return "LabelEntryView{nodeId=" + this.nodeId + ", label=" + this.label + "}";
    }
}

