/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Set;
import org.neo4j.internal.id.IdController;
import org.neo4j.kernel.impl.api.KernelTransactionStamp;

public class KernelTransactionsSnapshot
implements IdController.IdFreeCondition {
    private Tx relevantTransactions;

    KernelTransactionsSnapshot(Set<KernelTransactionStamp> transactionStamps) {
        Tx head = null;
        for (KernelTransactionStamp stamp : transactionStamps) {
            if (!stamp.isOpen()) continue;
            Tx current = new Tx(stamp);
            if (head != null) {
                current.next = head;
                head = current;
                continue;
            }
            head = current;
        }
        this.relevantTransactions = head;
    }

    public boolean eligibleForFreeing() {
        while (this.relevantTransactions != null) {
            if (!this.relevantTransactions.haveClosed()) {
                return false;
            }
            this.relevantTransactions = this.relevantTransactions.next;
        }
        return true;
    }

    private static class Tx {
        private final KernelTransactionStamp txStamp;
        private Tx next;

        Tx(KernelTransactionStamp tx) {
            this.txStamp = tx;
        }

        boolean haveClosed() {
            return !this.txStamp.isOpen();
        }
    }
}

