/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.concurrent.atomic.AtomicLong;

public interface DatabaseOperationCounts {
    public long startCount();

    public long createCount();

    public long stopCount();

    public long dropCount();

    public long failedCount();

    public long recoveredCount();

    public static class Counter
    implements DatabaseOperationCounts {
        private AtomicLong createCount = new AtomicLong(0L);
        private AtomicLong startCount = new AtomicLong(0L);
        private AtomicLong stopCount = new AtomicLong(0L);
        private AtomicLong dropCount = new AtomicLong(0L);
        private AtomicLong failedCount = new AtomicLong(0L);
        private AtomicLong recoveredCount = new AtomicLong(0L);

        @Override
        public long startCount() {
            return this.startCount.get();
        }

        @Override
        public long createCount() {
            return this.createCount.get();
        }

        @Override
        public long stopCount() {
            return this.stopCount.get();
        }

        @Override
        public long dropCount() {
            return this.dropCount.get();
        }

        @Override
        public long failedCount() {
            return this.failedCount.get();
        }

        @Override
        public long recoveredCount() {
            return this.recoveredCount.get();
        }

        public void increaseCreateCount() {
            this.createCount.incrementAndGet();
        }

        public void increaseStartCount() {
            this.startCount.incrementAndGet();
        }

        public void increaseStopCount() {
            this.stopCount.incrementAndGet();
        }

        public void increaseDropCount() {
            this.dropCount.incrementAndGet();
        }

        public void increaseFailedCount() {
            this.failedCount.incrementAndGet();
        }

        public void increaseRecoveredCount() {
            this.recoveredCount.incrementAndGet();
        }
    }
}

